/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.registry;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import fuzs.puzzleslib.PuzzlesLib;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryObject;
import org.apache.commons.lang3.StringUtils;

public class RegistryManager {
    private static final Map<String, RegistryManager> MOD_TO_REGISTRY = Maps.newConcurrentMap();
    private final String namespace;
    private final Multimap<Class<? extends IForgeRegistryEntry<?>>, Supplier<? extends IForgeRegistryEntry<?>>> registryToFactory = ArrayListMultimap.create();

    private RegistryManager(String namespace) {
        this.namespace = namespace;
    }

    @SubscribeEvent
    @Deprecated
    public void onRegistryRegister(RegistryEvent.Register<?> evt) {
        this.addAllToRegistry(evt.getRegistry());
    }

    public <T extends IForgeRegistryEntry<T>> void addAllToRegistry(IForgeRegistry<T> registry) {
        Collection suppliers = this.registryToFactory.get((Object)registry.getRegistrySuperType());
        if (!suppliers.isEmpty()) {
            PuzzlesLib.LOGGER.info("Registering {} element(s) to registry of type {} for mod id {}", new Object[]{suppliers.size(), registry.getRegistryName(), this.namespace});
            suppliers.forEach(entry -> registry.register((IForgeRegistryEntry)entry.get()));
        }
    }

    @Deprecated
    public <T extends IForgeRegistryEntry<T>, U extends T> RegistryObject<U> register(IForgeRegistry<T> registry, String path, Supplier<U> entry) {
        return this.register(registry.getRegistrySuperType(), path, entry);
    }

    public <T extends IForgeRegistryEntry<T>, U extends T> RegistryObject<U> register(Class<T> baseType, String path, Supplier<U> entry) {
        this.registryToFactory.put(baseType, () -> {
            IForgeRegistryEntry e = (IForgeRegistryEntry)entry.get();
            Objects.requireNonNull(e, "Can't register null object");
            e.setRegistryName(this.locate(path));
            return e;
        });
        return RegistryObject.of((ResourceLocation)this.locate(path), baseType, (String)this.namespace);
    }

    public RegistryObject<Block> registerBlock(String path, Supplier<Block> entry) {
        return this.register(Block.class, path, entry);
    }

    public RegistryObject<Block> registerBlockWithItem(String path, Supplier<Block> entry, CreativeModeTab creativeTab) {
        return this.registerBlockWithItem(path, entry, new Item.Properties().m_41491_(creativeTab));
    }

    public RegistryObject<Block> registerBlockWithItem(String path, Supplier<Block> entry, Item.Properties properties) {
        RegistryObject<Block> block = this.registerBlock(path, entry);
        this.registerBlockItem(path, properties);
        return block;
    }

    public RegistryObject<Fluid> registerFluid(String path, Supplier<Fluid> entry) {
        return this.register(Fluid.class, path, entry);
    }

    public RegistryObject<Item> registerItem(String path, Supplier<Item> entry) {
        return this.register(Item.class, path, entry);
    }

    public RegistryObject<Item> registerItem(String path, Function<Item.Properties, Item> entry, CreativeModeTab creativeTab) {
        return this.registerItem(path, () -> (Item)entry.apply(new Item.Properties().m_41491_(creativeTab)));
    }

    public RegistryObject<Item> registerBlockItem(String path, CreativeModeTab creativeTab) {
        return this.registerBlockItem(path, new Item.Properties().m_41491_(creativeTab));
    }

    public RegistryObject<Item> registerBlockItem(String path, Item.Properties properties) {
        return this.registerItem(path, () -> {
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(this.locate(path));
            Objects.requireNonNull(block, "Can't register item for null block");
            return new BlockItem(block, properties);
        });
    }

    public RegistryObject<MobEffect> registerMobEffect(String path, Supplier<MobEffect> entry) {
        return this.register(MobEffect.class, path, entry);
    }

    public RegistryObject<SoundEvent> registerRawSoundEvent(String path) {
        return this.registerSoundEvent(path, () -> new SoundEvent(this.locate(path)));
    }

    public RegistryObject<SoundEvent> registerSoundEvent(String path, Supplier<SoundEvent> entry) {
        return this.register(SoundEvent.class, path, entry);
    }

    public RegistryObject<Potion> registerPotion(String path, Supplier<Potion> entry) {
        return this.register(Potion.class, path, entry);
    }

    public RegistryObject<Enchantment> registerEnchantment(String path, Supplier<Enchantment> entry) {
        return this.register(Enchantment.class, path, entry);
    }

    public <T extends Entity> RegistryObject<EntityType<T>> registerRawEntityType(String path, Supplier<EntityType.Builder<T>> entry) {
        return this.registerEntityType(path, () -> ((EntityType.Builder)entry.get()).m_20712_(path));
    }

    public <T extends Entity> RegistryObject<EntityType<T>> registerEntityType(String path, Supplier<EntityType<T>> entry) {
        return this.register(EntityType.class, path, entry);
    }

    public <T extends BlockEntity> RegistryObject<BlockEntityType<T>> registerRawBlockEntityType(String path, Supplier<BlockEntityType.Builder<T>> entry) {
        return this.registerBlockEntityType(path, () -> ((BlockEntityType.Builder)entry.get()).m_58966_(null));
    }

    public <T extends BlockEntity> RegistryObject<BlockEntityType<T>> registerBlockEntityType(String path, Supplier<BlockEntityType<T>> entry) {
        return this.register(BlockEntityType.class, path, entry);
    }

    public <T extends AbstractContainerMenu> RegistryObject<MenuType<T>> registerRawMenuType(String path, Supplier<MenuType.MenuSupplier<T>> entry) {
        return this.registerMenuType(path, () -> new MenuType((MenuType.MenuSupplier)entry.get()));
    }

    public <T extends AbstractContainerMenu> RegistryObject<MenuType<T>> registerMenuType(String path, Supplier<MenuType<T>> entry) {
        return this.register(MenuType.class, path, entry);
    }

    private ResourceLocation locate(String path) {
        if (StringUtils.isEmpty((CharSequence)path)) {
            throw new IllegalArgumentException("Can't register object without name");
        }
        return new ResourceLocation(this.namespace, path);
    }

    public static synchronized RegistryManager of(String namespace) {
        return MOD_TO_REGISTRY.computeIfAbsent(namespace, key -> {
            PuzzlesLib.LOGGER.info("Creating registry manager for mod id {}", (Object)namespace);
            RegistryManager manager = new RegistryManager(namespace);
            FMLJavaModLoadingContext.get().getModEventBus().register((Object)manager);
            String activeNamespace = ModLoadingContext.get().getActiveNamespace();
            if (!activeNamespace.equals(namespace)) {
                PuzzlesLib.LOGGER.error("Registering registry manager for wrong mod loading context! Expected {}, but received {} instead", (Object)namespace, (Object)activeNamespace);
            }
            return manager;
        });
    }
}

