/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.network.node;

import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.api.network.node.INetworkNode;
import com.refinedmods.refinedstorage.api.util.Action;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.apiimpl.network.node.ExternalStorageNetworkNode;
import com.refinedmods.refinedstorage.apiimpl.network.node.NetworkNode;
import com.refinedmods.refinedstorage.apiimpl.network.node.SlottedCraftingRequest;
import com.refinedmods.refinedstorage.apiimpl.storage.externalstorage.ItemExternalStorage;
import com.refinedmods.refinedstorage.blockentity.config.IComparable;
import com.refinedmods.refinedstorage.inventory.item.BaseItemHandler;
import com.refinedmods.refinedstorage.inventory.item.ProxyItemHandler;
import com.refinedmods.refinedstorage.inventory.item.UpgradeItemHandler;
import com.refinedmods.refinedstorage.inventory.listener.NetworkNodeInventoryListener;
import com.refinedmods.refinedstorage.item.UpgradeItem;
import com.refinedmods.refinedstorage.util.StackUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class InterfaceNetworkNode
extends NetworkNode
implements IComparable {
    public static final ResourceLocation ID = new ResourceLocation("refinedstorage", "interface");
    private static final String NBT_COMPARE = "Compare";
    private final BaseItemHandler importItems = new BaseItemHandler(9).addListener(new NetworkNodeInventoryListener(this));
    private final BaseItemHandler exportFilterItems = new BaseItemHandler(9).addListener(new NetworkNodeInventoryListener(this));
    private final BaseItemHandler exportItems = new BaseItemHandler(9).addListener(new NetworkNodeInventoryListener(this));
    private final IItemHandler items = new ProxyItemHandler((IItemHandler)this.importItems, (IItemHandler)this.exportItems);
    private final UpgradeItemHandler upgrades = (UpgradeItemHandler)new UpgradeItemHandler(4, UpgradeItem.Type.SPEED, UpgradeItem.Type.STACK, UpgradeItem.Type.CRAFTING).addListener(new NetworkNodeInventoryListener(this));
    private int compare = 1;
    private int currentSlot = 0;

    public InterfaceNetworkNode(Level level, BlockPos pos) {
        super(level, pos);
    }

    @Override
    public int getEnergyUsage() {
        return RS.SERVER_CONFIG.getInterface().getUsage() + this.upgrades.getEnergyUsage();
    }

    @Override
    public void update() {
        ItemStack slot;
        super.update();
        if (!this.canUpdate()) {
            return;
        }
        if (this.currentSlot >= this.importItems.getSlots()) {
            this.currentSlot = 0;
        }
        if ((slot = this.importItems.getStackInSlot(this.currentSlot)).m_41619_()) {
            ++this.currentSlot;
        } else if (this.ticks % this.upgrades.getSpeed() == 0) {
            int size = Math.min(slot.m_41613_(), this.upgrades.getStackInteractCount());
            ItemStack remainder = this.network.insertItemTracked(slot, size);
            this.importItems.extractItem(this.currentSlot, size - remainder.m_41613_(), false);
        }
        for (int i = 0; i < 9; ++i) {
            int delta;
            ItemStack wanted = this.exportFilterItems.getStackInSlot(i);
            ItemStack got = this.exportItems.getStackInSlot(i);
            if (wanted.m_41619_()) {
                if (got.m_41619_()) continue;
                this.exportItems.setStackInSlot(i, this.network.insertItemTracked(got, got.m_41613_()));
                continue;
            }
            if (!got.m_41619_() && !API.instance().getComparer().isEqual(wanted, got, this.getCompare())) {
                this.exportItems.setStackInSlot(i, this.network.insertItemTracked(got, got.m_41613_()));
                continue;
            }
            int n = delta = got.m_41619_() ? wanted.m_41613_() : wanted.m_41613_() - got.m_41613_();
            if (delta > 0) {
                boolean actingAsStorage = this.isActingAsStorage();
                ItemStack result = this.network.extractItem(wanted, delta, this.compare, Action.PERFORM, s -> {
                    if (!actingAsStorage) {
                        return true;
                    }
                    return !(s instanceof ItemExternalStorage) || !((ItemExternalStorage)s).isConnectedToInterface();
                });
                if (!result.m_41619_()) {
                    if (this.exportItems.getStackInSlot(i).m_41619_()) {
                        this.exportItems.setStackInSlot(i, result);
                    } else {
                        this.exportItems.getStackInSlot(i).m_41769_(result.m_41613_());
                    }
                }
                if ((delta -= result.m_41613_()) <= 0 || !this.upgrades.hasUpgrade(UpgradeItem.Type.CRAFTING)) continue;
                this.network.getCraftingManager().request((Object)new SlottedCraftingRequest(this, i), wanted, delta);
                continue;
            }
            if (delta >= 0) continue;
            ItemStack remainder = this.network.insertItemTracked(got, Math.abs(delta));
            this.exportItems.extractItem(i, Math.abs(delta) - remainder.m_41613_(), false);
        }
    }

    private boolean isActingAsStorage() {
        for (Direction facing : Direction.values()) {
            INetworkNode facingNode = API.instance().getNetworkNodeManager((ServerLevel)this.level).getNode(this.pos.m_142300_(facing));
            if (!(facingNode instanceof ExternalStorageNetworkNode) || !facingNode.isActive() || ((ExternalStorageNetworkNode)facingNode).getDirection() != facing.m_122424_() || ((ExternalStorageNetworkNode)facingNode).getType() != 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getCompare() {
        return this.compare;
    }

    @Override
    public void setCompare(int compare) {
        this.compare = compare;
        this.markDirty();
    }

    @Override
    public void read(CompoundTag tag) {
        super.read(tag);
        StackUtils.readItems(this.importItems, 0, tag);
        StackUtils.readItems(this.exportItems, 2, tag);
        StackUtils.readItems(this.upgrades, 3, tag);
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public CompoundTag write(CompoundTag tag) {
        super.write(tag);
        StackUtils.writeItems((IItemHandler)this.importItems, 0, tag);
        StackUtils.writeItems((IItemHandler)this.exportItems, 2, tag);
        StackUtils.writeItems((IItemHandler)this.upgrades, 3, tag);
        return tag;
    }

    @Override
    public CompoundTag writeConfiguration(CompoundTag tag) {
        super.writeConfiguration(tag);
        StackUtils.writeItems((IItemHandler)this.exportFilterItems, 1, tag);
        tag.m_128405_(NBT_COMPARE, this.compare);
        return tag;
    }

    @Override
    public void readConfiguration(CompoundTag tag) {
        super.readConfiguration(tag);
        StackUtils.readItems(this.exportFilterItems, 1, tag);
        if (tag.m_128441_(NBT_COMPARE)) {
            this.compare = tag.m_128451_(NBT_COMPARE);
        }
    }

    public IItemHandler getImportItems() {
        return this.importItems;
    }

    public IItemHandler getExportFilterItems() {
        return this.exportFilterItems;
    }

    public IItemHandler getExportItems() {
        return this.exportItems;
    }

    public IItemHandler getItems() {
        return this.items;
    }

    public IItemHandler getUpgrades() {
        return this.upgrades;
    }

    @Override
    public IItemHandler getDrops() {
        return new CombinedInvWrapper(new IItemHandlerModifiable[]{this.importItems, this.exportItems, this.upgrades});
    }
}

