/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.advancements.predicates;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.budschie.bmorph.capabilities.IMorphCapability;
import de.budschie.bmorph.morph.MorphItem;
import net.minecraft.advancements.critereon.EntityTypePredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.nbt.Tag;

public class MorphPredicate {
    private EntityTypePredicate entityType;
    private MinMaxBounds.Ints count;
    private NbtPredicate nbtPredicate;

    public MorphPredicate(EntityTypePredicate entityType, MinMaxBounds.Ints count, NbtPredicate nbtPredicate) {
        this.entityType = entityType;
        this.count = count;
        this.nbtPredicate = nbtPredicate;
    }

    public MorphPredicate() {
    }

    public boolean matches(MorphItem morphItem, IMorphCapability cap) {
        if (this.entityType != null && !this.entityType.m_7484_(morphItem.getEntityType())) {
            return false;
        }
        if (this.count != null && morphItem != null && cap != null && !this.count.m_55390_(cap.getMorphList().getEntityCount(morphItem.getEntityType()))) {
            return false;
        }
        return this.nbtPredicate == null || morphItem == null || this.nbtPredicate.m_57483_((Tag)morphItem.serializeAdditional());
    }

    public JsonElement serializeToJson() {
        JsonObject object = new JsonObject();
        if (this.entityType != null) {
            object.add("entity_type", this.entityType.m_5908_());
        }
        if (this.count != null) {
            object.add("morph_count", this.count.m_55328_());
        }
        if (this.nbtPredicate != null) {
            object.add("nbt", this.nbtPredicate.m_57476_());
        }
        return object;
    }

    public static MorphPredicate fromJson(JsonElement jsonElement) {
        if (jsonElement == null || !jsonElement.isJsonObject()) {
            return new MorphPredicate();
        }
        EntityTypePredicate entityType = null;
        MinMaxBounds.Ints count = null;
        NbtPredicate nbtPredicate = null;
        JsonObject root = (JsonObject)jsonElement;
        if (root.has("entity_type")) {
            entityType = EntityTypePredicate.m_37643_((JsonElement)root.get("entity_type"));
        }
        if (root.has("morph_count")) {
            count = MinMaxBounds.Ints.m_55373_((JsonElement)root.get("morph_count"));
        }
        if (root.has("nbt")) {
            nbtPredicate = NbtPredicate.m_57481_((JsonElement)root.get("nbt"));
        }
        return new MorphPredicate(entityType, count, nbtPredicate);
    }
}

