/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.capabilities;

import de.budschie.bmorph.main.BMorphMod;
import de.budschie.bmorph.morph.functionality.Ability;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;

public class AbilitySerializationContext {
    private HashMap<ResourceLocation, AbilitySerializationObject> abilityMap = new HashMap();

    public AbilitySerializationObject getOrCreateSerializationObjectForAbility(Ability ability) {
        AbilitySerializationObject object = new AbilitySerializationObject();
        this.abilityMap.put(ability.getResourceLocation(), object);
        return object;
    }

    public AbilitySerializationObject getSerializationObjectForAbilityOrNull(Ability ability) {
        return this.abilityMap.get(ability.getResourceLocation());
    }

    public Optional<AbilitySerializationObject> getSerializationObjectForAbility(Ability ability) {
        return Optional.ofNullable(this.abilityMap.get(ability.getResourceLocation()));
    }

    public void deleteSerializationObjectForAbility(Ability ability) {
        this.abilityMap.remove(ability.getResourceLocation());
    }

    public void clearTransientData() {
        this.abilityMap.forEach((key, value) -> value.setTransientTag(Optional.empty()));
    }

    public void clearTransientDataFor(Ability ability) {
        AbilitySerializationObject object = this.abilityMap.get(ability.getResourceLocation());
        if (object != null) {
            object.setTransientTag(Optional.empty());
        }
    }

    public CompoundTag serialize() {
        CompoundTag rootTag = new CompoundTag();
        for (Map.Entry<ResourceLocation, AbilitySerializationObject> entries : this.abilityMap.entrySet()) {
            CompoundTag entryTag = new CompoundTag();
            entries.getValue().getPersistentTag().ifPresent(persistentTag -> entryTag.m_128365_("persistent", (Tag)persistentTag));
            entries.getValue().getTransientTag().ifPresent(transientTag -> entryTag.m_128365_("transient", (Tag)transientTag));
            rootTag.m_128365_(entries.getKey().toString(), (Tag)entryTag);
        }
        return rootTag;
    }

    public static AbilitySerializationContext deserialize(CompoundTag deserializeFrom) {
        AbilitySerializationContext context = new AbilitySerializationContext();
        for (String ability : deserializeFrom.m_128431_()) {
            Ability foundAbility = (Ability)BMorphMod.DYNAMIC_ABILITY_REGISTRY.getEntry(new ResourceLocation(ability));
            if (foundAbility == null) continue;
            AbilitySerializationObject object = new AbilitySerializationObject();
            CompoundTag entryTag = deserializeFrom.m_128469_(ability);
            if (entryTag.m_128441_("transient")) {
                object.setTransientTag(Optional.of(entryTag.m_128469_("transient")));
            }
            if (entryTag.m_128441_("persistent")) {
                object.setPersistentTag(Optional.of(entryTag.m_128469_("persistent")));
            }
            context.abilityMap.put(foundAbility.getResourceLocation(), object);
        }
        return context;
    }

    public static class AbilitySerializationObject {
        private Optional<CompoundTag> transientTag = Optional.empty();
        private Optional<CompoundTag> persistentTag = Optional.empty();

        public Optional<CompoundTag> getTransientTag() {
            return this.transientTag;
        }

        public Optional<CompoundTag> getPersistentTag() {
            return this.persistentTag;
        }

        public void setPersistentTag(Optional<CompoundTag> persistentTag) {
            this.persistentTag = persistentTag;
        }

        public void setTransientTag(Optional<CompoundTag> transientTag) {
            this.transientTag = transientTag;
        }

        public CompoundTag createTransientTag() {
            this.transientTag = Optional.of(new CompoundTag());
            return this.transientTag.get();
        }

        public CompoundTag createPersistentTag() {
            this.persistentTag = Optional.of(new CompoundTag());
            return this.persistentTag.get();
        }

        public CompoundTag getOrCreateTransientTag() {
            if (this.transientTag.isEmpty()) {
                this.createTransientTag();
            }
            return this.transientTag.get();
        }

        public CompoundTag getOrCreatePersistentTag() {
            if (this.persistentTag.isEmpty()) {
                this.createPersistentTag();
            }
            return this.persistentTag.get();
        }
    }
}

