/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.capabilities;

import com.google.common.collect.Lists;
import de.budschie.bmorph.capabilities.AbilitySerializationContext;
import de.budschie.bmorph.capabilities.IMorphCapability;
import de.budschie.bmorph.morph.FavouriteList;
import de.budschie.bmorph.morph.MorphItem;
import de.budschie.bmorph.morph.MorphList;
import de.budschie.bmorph.morph.functionality.Ability;
import de.budschie.bmorph.network.AdditionalAbilitySynchronization;
import de.budschie.bmorph.network.MainNetworkChannel;
import de.budschie.bmorph.network.MorphAddedSynchronizer;
import de.budschie.bmorph.network.MorphCapabilityFullSynchronizer;
import de.budschie.bmorph.network.MorphChangedSynchronizer;
import de.budschie.bmorph.network.MorphRemovedSynchronizer;
import de.budschie.bmorph.util.LockableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.PacketDistributor;

public class DefaultMorphCapability
implements IMorphCapability {
    Player owner;
    boolean mobAttack = false;
    int aggroTimestamp = 0;
    int aggroDuration = 0;
    Optional<MorphItem> morph = Optional.empty();
    Optional<Integer> currentMorphIndex = Optional.empty();
    MorphList morphList = new MorphList();
    FavouriteList favouriteList = new FavouriteList(this.morphList);
    LockableList<Ability> currentAbilities = new LockableList();
    AbilitySerializationContext context = new AbilitySerializationContext();

    @Override
    public AbilitySerializationContext getAbilitySerializationContext() {
        return this.context;
    }

    @Override
    public void setAbilitySerializationContext(AbilitySerializationContext context) {
        this.context = context;
    }

    public DefaultMorphCapability(Player owner) {
        this.owner = owner;
    }

    @Override
    public Player getOwner() {
        return this.owner;
    }

    @Override
    public void syncWithClients() {
        if (this.getOwner().f_19853_.f_46443_) {
            throw new IllegalAccessError("This method may not be called on client side.");
        }
        MainNetworkChannel.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> this.getOwner()), (Object)new MorphCapabilityFullSynchronizer.MorphPacket(this.morph, this.currentMorphIndex, this.morphList, this.favouriteList, this.serializeAbilities(), this.getOwner().m_142081_()));
    }

    @Override
    public void syncWithClient(ServerPlayer syncTo) {
        if (this.getOwner().f_19853_.f_46443_) {
            throw new IllegalAccessError("This method may not be called on client side.");
        }
        MainNetworkChannel.INSTANCE.send(PacketDistributor.PLAYER.with(() -> syncTo), (Object)new MorphCapabilityFullSynchronizer.MorphPacket(this.morph, this.currentMorphIndex, this.morphList, this.favouriteList, this.serializeAbilities(), this.getOwner().m_142081_()));
    }

    @Override
    public void syncWithConnection(Connection connection) {
        if (this.getOwner().f_19853_.f_46443_) {
            throw new IllegalAccessError("This method may not be called on client side.");
        }
        MainNetworkChannel.INSTANCE.send(PacketDistributor.NMLIST.with(() -> Lists.newArrayList((Object[])new Connection[]{connection})), (Object)new MorphCapabilityFullSynchronizer.MorphPacket(this.morph, this.currentMorphIndex, this.morphList, this.favouriteList, this.serializeAbilities(), this.getOwner().m_142081_()));
    }

    @Override
    public void syncMorphChange() {
        if (this.getOwner().f_19853_.f_46443_) {
            throw new IllegalAccessError("This method may not be called on client side.");
        }
        MainNetworkChannel.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)this.getOwner()), (Object)new MorphChangedSynchronizer.MorphChangedPacket(this.getOwner().m_142081_(), this.currentMorphIndex, this.morph, this.serializeAbilities()));
        MainNetworkChannel.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> this.getOwner()), (Object)new MorphChangedSynchronizer.MorphChangedPacket(this.getOwner().m_142081_(), Optional.empty(), this.getCurrentMorph(), this.serializeAbilities()));
    }

    @Override
    public void syncMorphAcquisition(MorphItem item) {
        if (this.getOwner().f_19853_.f_46443_) {
            throw new IllegalAccessError("This method may not be called on client side.");
        }
        MainNetworkChannel.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)this.getOwner()), (Object)new MorphAddedSynchronizer.MorphAddedPacket(this.getOwner().m_142081_(), item));
    }

    @Override
    public void syncMorphRemoval(int index) {
        if (this.getOwner().f_19853_.f_46443_) {
            throw new IllegalAccessError("This method may not be called on client side.");
        }
        MainNetworkChannel.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)this.getOwner()), (Object)new MorphRemovedSynchronizer.MorphRemovedPacket(this.getOwner().m_142081_(), index));
    }

    @Override
    public void syncAbilityAddition(Ability ... abilities) {
        if (this.getOwner().f_19853_.f_46443_) {
            throw new IllegalAccessError("This method may not be called on client side.");
        }
        MainNetworkChannel.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> this.getOwner()), (Object)new AdditionalAbilitySynchronization.AdditionalAbilitySynchronizationPacket(this.getOwner().m_142081_(), true, abilities));
    }

    @Override
    public void syncAbilityRemoval(Ability ... abilities) {
        if (this.getOwner().f_19853_.f_46443_) {
            throw new IllegalAccessError("This method may not be called on client side.");
        }
        MainNetworkChannel.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> this.getOwner()), (Object)new AdditionalAbilitySynchronization.AdditionalAbilitySynchronizationPacket(this.getOwner().m_142081_(), false, abilities));
    }

    private ArrayList<String> serializeAbilities() {
        if (this.getCurrentAbilities() == null || this.getCurrentAbilities().size() == 0) {
            return new ArrayList<String>();
        }
        ArrayList<String> toString = new ArrayList<String>();
        for (Ability ability : this.getCurrentAbilities()) {
            toString.add(ability.getResourceLocation().toString());
        }
        return toString;
    }

    @Override
    public int addToMorphList(MorphItem morphItem) {
        return this.morphList.addToMorphList(morphItem);
    }

    @Override
    public void removeFromMorphList(int index) {
        this.morphList.removeFromMorphList(index);
    }

    @Override
    public void setMorphList(MorphList list) {
        this.morphList = list;
        this.favouriteList.setMorphList(this.morphList);
    }

    @Override
    public MorphList getMorphList() {
        return this.morphList;
    }

    @Override
    public void applyHealthOnPlayer() {
        float playerHealthPercentage = this.getOwner().m_21223_() / this.getOwner().m_21233_();
        if (!this.getCurrentMorph().isPresent()) {
            this.getOwner().m_21051_(Attributes.f_22276_).m_22100_(20.0);
            this.getOwner().m_21153_(20.0f * playerHealthPercentage);
        } else {
            Entity thisisnotveryperformantoranythinglikethisbutidontcarealsothisnameisverystupidsoidkmaybeishouldhchangethislaterbutontheotherhandthisisalsobtwyouhavejustfoundaneasteregginmycode = this.getCurrentMorph().get().createEntity(this.getOwner().f_19853_);
            if (thisisnotveryperformantoranythinglikethisbutidontcarealsothisnameisverystupidsoidkmaybeishouldhchangethislaterbutontheotherhandthisisalsobtwyouhavejustfoundaneasteregginmycode instanceof LivingEntity) {
                float maxHealthOfEntity = ((LivingEntity)thisisnotveryperformantoranythinglikethisbutidontcarealsothisnameisverystupidsoidkmaybeishouldhchangethislaterbutontheotherhandthisisalsobtwyouhavejustfoundaneasteregginmycode).m_21233_();
                this.getOwner().m_21051_(Attributes.f_22276_).m_22100_((double)maxHealthOfEntity);
                this.getOwner().m_21153_(maxHealthOfEntity * playerHealthPercentage);
            } else {
                this.getOwner().m_21051_(Attributes.f_22276_).m_22100_(20.0);
                this.getOwner().m_21153_(20.0f * playerHealthPercentage);
            }
        }
    }

    @Override
    public Optional<Integer> getCurrentMorphIndex() {
        return this.currentMorphIndex;
    }

    @Override
    public Optional<MorphItem> getCurrentMorphItem() {
        return this.morph;
    }

    @Override
    public Optional<MorphItem> getCurrentMorph() {
        if (this.currentMorphIndex.isPresent()) {
            return Optional.of(this.getMorphList().getMorphArrayList().get(this.currentMorphIndex.get()));
        }
        if (this.morph.isPresent()) {
            return this.morph;
        }
        return Optional.empty();
    }

    @Override
    public void setMorph(int index) {
        this.morph = Optional.empty();
        this.currentMorphIndex = Optional.of(index);
    }

    @Override
    public void setMorph(MorphItem morph) {
        this.morph = Optional.of(morph);
        this.currentMorphIndex = Optional.empty();
    }

    @Override
    public void demorph() {
        this.morph = Optional.empty();
        this.currentMorphIndex = Optional.empty();
    }

    @Override
    public List<Ability> getCurrentAbilities() {
        return this.currentAbilities == null ? null : this.currentAbilities.getList();
    }

    @Override
    public void setCurrentAbilities(List<Ability> abilities) {
        this.currentAbilities = new LockableList<Ability>(abilities);
    }

    @Override
    public void applyAbilities(MorphItem oldMorphItem, List<Ability> oldAbilities) {
        if (this.getCurrentAbilities() != null && this.getCurrentMorph().isPresent()) {
            this.currentAbilities.lock();
            this.currentAbilities.getList().forEach(ability -> {
                if (!this.getOwner().f_19853_.m_5776_()) {
                    ability.deserialize(this.getOwner(), this.context);
                }
                ability.enableAbility(this.getOwner(), this.getCurrentMorph().get(), oldMorphItem, oldAbilities, Ability.AbilityChangeReason.MORPHED);
            });
            this.currentAbilities.unlock();
        }
    }

    @Override
    public void deapplyAbilities(MorphItem aboutToMorphTo, List<Ability> newAbilities) {
        if (this.getCurrentAbilities() != null) {
            this.currentAbilities.lock();
            this.currentAbilities.getList().forEach(ability -> {
                if (!this.getOwner().f_19853_.m_5776_()) {
                    ability.serialize(this.getOwner(), this.context, false);
                }
                ability.disableAbility(this.getOwner(), this.getCurrentMorph().get(), aboutToMorphTo, newAbilities, Ability.AbilityChangeReason.MORPHED);
            });
            this.currentAbilities.unlock();
            this.removePlayerReferences();
            if (!this.getOwner().f_19853_.m_5776_()) {
                this.context.clearTransientData();
            }
        }
    }

    @Override
    public void useAbility() {
        if (this.getCurrentAbilities() != null) {
            this.currentAbilities.lock();
            this.currentAbilities.getList().forEach(ability -> ability.onUsedAbility(this.getOwner(), this.getCurrentMorph().get()));
            this.currentAbilities.unlock();
        }
    }

    @Override
    public int getLastAggroTimestamp() {
        return this.aggroTimestamp;
    }

    @Override
    public void setLastAggroTimestamp(int timestamp) {
        this.aggroTimestamp = timestamp;
    }

    @Override
    public int getLastAggroDuration() {
        return this.aggroDuration;
    }

    @Override
    public void setLastAggroDuration(int aggroDuration) {
        this.aggroDuration = aggroDuration;
    }

    @Override
    public FavouriteList getFavouriteList() {
        return this.favouriteList;
    }

    @Override
    public void setFavouriteList(FavouriteList favouriteList) {
        this.favouriteList = favouriteList;
    }

    @Override
    public boolean shouldMobsAttack() {
        return this.mobAttack;
    }

    @Override
    public void setMobAttack(boolean value) {
        this.mobAttack = value;
    }

    @Override
    public void applyAbility(Ability ability) {
        if (this.getCurrentAbilities() == null) {
            this.currentAbilities = new LockableList<Ability>(Arrays.asList(ability));
        } else {
            if (this.getCurrentAbilities().contains(ability)) {
                return;
            }
            this.currentAbilities.safeAdd(ability);
            if (!this.getOwner().f_19853_.m_5776_()) {
                ability.deserialize(this.getOwner(), this.context);
            }
            ability.enableAbility(this.getOwner(), this.getCurrentMorph().orElse(null), null, Arrays.asList(new Ability[0]), Ability.AbilityChangeReason.DYNAMIC);
        }
    }

    @Override
    public void deapplyAbility(Ability ability) {
        if (this.getCurrentAbilities() != null) {
            this.currentAbilities.safeRemove(ability);
            if (!this.getOwner().f_19853_.m_5776_()) {
                ability.serialize(this.owner, this.context, false);
            }
            ability.disableAbility(this.getOwner(), this.getCurrentMorph().orElse(null), null, Arrays.asList(new Ability[0]), Ability.AbilityChangeReason.DYNAMIC);
            if (!this.getOwner().f_19853_.m_5776_()) {
                this.context.clearTransientDataFor(ability);
            }
            ability.removePlayerReferences(this.owner);
        }
    }

    @Override
    public CompoundTag serializeSavableAbilityData() {
        if (this.currentAbilities == null || this.currentAbilities.getList() == null) {
            return this.context.serialize();
        }
        this.currentAbilities.lock();
        for (Ability ability : this.currentAbilities.getList()) {
            ability.serialize(this.getOwner(), this.context, true);
        }
        this.currentAbilities.unlock();
        return this.context.serialize();
    }

    @Override
    public void deserializeSavableAbilityData(CompoundTag compoundTag) {
        this.context = AbilitySerializationContext.deserialize(compoundTag);
    }

    @Override
    public void removePlayerReferences() {
        if (this.getCurrentAbilities() != null) {
            this.getCurrentAbilities().forEach(ability -> ability.removePlayerReferences(this.owner));
        }
    }
}

