/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.capabilities;

import de.budschie.bmorph.capabilities.AbilitySerializationContext;
import de.budschie.bmorph.capabilities.DefaultMorphCapability;
import de.budschie.bmorph.capabilities.IMorphCapability;
import de.budschie.bmorph.main.ServerSetup;
import de.budschie.bmorph.morph.MorphHandler;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class MorphCapabilityAttacher
implements ICapabilitySerializable<CompoundTag> {
    public static final ResourceLocation CAPABILITY_NAME = new ResourceLocation("bmorph", "morph_cap");
    public static final Capability<IMorphCapability> MORPH_CAP = CapabilityManager.get((CapabilityToken)new CapabilityToken<IMorphCapability>(){});
    private Player owner;
    LazyOptional<IMorphCapability> cap = LazyOptional.of(() -> new DefaultMorphCapability(this.owner));

    @SubscribeEvent
    public static void onAttachCapsOnPlayer(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player) {
            event.addCapability(CAPABILITY_NAME, (ICapabilityProvider)new MorphCapabilityAttacher((Player)event.getObject()));
        }
    }

    public MorphCapabilityAttacher(Player owner) {
        this.owner = owner;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        return MORPH_CAP.orEmpty(cap, this.cap);
    }

    public CompoundTag serializeNBT() {
        CompoundTag capTag = new CompoundTag();
        IMorphCapability instance = (IMorphCapability)this.cap.resolve().get();
        if (instance.getCurrentMorphItem().isPresent()) {
            capTag.m_128365_("currentMorphItem", (Tag)instance.getCurrentMorphItem().get().serialize());
        }
        if (instance.getCurrentMorphIndex().isPresent()) {
            capTag.m_128405_("currentMorphIndex", instance.getCurrentMorphIndex().get().intValue());
        }
        capTag.m_128365_("morphList", (Tag)instance.getMorphList().serializeNBT());
        capTag.m_128365_("favouriteList", (Tag)instance.getFavouriteList().serialize());
        capTag.m_128405_("aggroDuration", Math.max(0, instance.getLastAggroDuration() - (ServerSetup.server.m_129921_() - instance.getLastAggroTimestamp())));
        capTag.m_128365_("savableAbilities", (Tag)instance.serializeSavableAbilityData());
        return capTag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        CompoundTag capTag = nbt;
        IMorphCapability instance = (IMorphCapability)this.cap.resolve().get();
        boolean hasItem = capTag.m_128441_("currentMorphItem");
        boolean hasIndex = capTag.m_128441_("currentMorphIndex");
        if (hasItem) {
            instance.setMorph(MorphHandler.deserializeMorphItem(capTag.m_128469_("currentMorphItem")));
        } else if (hasIndex) {
            instance.setMorph(capTag.m_128451_("currentMorphIndex"));
        }
        instance.getMorphList().deserializeNBT(capTag.m_128469_("morphList"));
        instance.getFavouriteList().deserialize(capTag.m_128469_("favouriteList"));
        instance.setLastAggroDuration(capTag.m_128451_("aggroDuration"));
        instance.setAbilitySerializationContext(AbilitySerializationContext.deserialize(capTag.m_128469_("savableAbilities")));
    }
}

