/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.capabilities.client.render_data;

import com.mojang.blaze3d.vertex.PoseStack;
import de.budschie.bmorph.capabilities.IMorphCapability;
import de.budschie.bmorph.capabilities.client.render_data.IRenderDataCapability;
import de.budschie.bmorph.morph.MorphUtil;
import de.budschie.bmorph.render_handler.EntitySynchronizerRegistry;
import de.budschie.bmorph.render_handler.IEntitySynchronizer;
import de.budschie.bmorph.render_handler.IEntitySynchronizerWithRotation;
import de.budschie.bmorph.render_handler.InitializeMorphEntityEvent;
import de.budschie.bmorph.render_handler.animations.AbstractMorphChangeAnimation;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class RenderDataCapability
implements IRenderDataCapability {
    private Optional<AbstractMorphChangeAnimation> animation = Optional.empty();
    private Entity cachedEntity;
    private ArrayList<IEntitySynchronizer> cachedSynchronizers;
    private ArrayList<IEntitySynchronizerWithRotation> cachedRotationSynchronizers;

    @Override
    public void setAnimation(Optional<AbstractMorphChangeAnimation> animation) {
        this.animation = animation;
    }

    @Override
    public void tickAnimation() {
        if (this.animation.isPresent()) {
            this.animation.get().tick();
            if (this.animation.get().getAnimationDuration() == this.animation.get().getTicks()) {
                this.animation = Optional.empty();
            }
        }
    }

    @Override
    public void renderAnimation(Player player, PoseStack poseStack, float partialTicks, MultiBufferSource buffer, int light) {
        this.animation.ifPresent(presentAnimation -> presentAnimation.render(poseStack, partialTicks, buffer, light));
    }

    @Override
    public boolean hasAnimation() {
        return this.animation.isPresent();
    }

    @Override
    public Entity getOrCreateCachedEntity(Player player) {
        IMorphCapability cap;
        if (this.cachedEntity == null && (cap = MorphUtil.getCapOrNull(player)) != null && cap.getCurrentMorph().isPresent()) {
            this.cachedEntity = cap.getCurrentMorph().get().createEntity(player.f_19853_);
            MinecraftForge.EVENT_BUS.post((Event)new InitializeMorphEntityEvent(player, this.cachedEntity));
        }
        return this.cachedEntity;
    }

    @Override
    public ArrayList<IEntitySynchronizer> getOrCreateCachedSynchronizers(Player player) {
        Entity entity;
        if (this.cachedSynchronizers == null && (entity = this.getOrCreateCachedEntity(player)) != null) {
            this.cachedSynchronizers = EntitySynchronizerRegistry.getSynchronizersForEntity(entity);
        }
        return this.cachedSynchronizers;
    }

    @Override
    public ArrayList<IEntitySynchronizerWithRotation> getOrCreateCachedRotationSynchronizers(Player player) {
        if (this.cachedRotationSynchronizers == null) {
            this.getOrCreateCachedSynchronizers(player);
            this.cachedRotationSynchronizers = new ArrayList();
            for (IEntitySynchronizer sync : this.cachedSynchronizers) {
                if (!(sync instanceof IEntitySynchronizerWithRotation)) continue;
                IEntitySynchronizerWithRotation withRotation = (IEntitySynchronizerWithRotation)sync;
                this.cachedRotationSynchronizers.add(withRotation);
            }
        }
        return this.cachedRotationSynchronizers;
    }

    @Override
    public void setEntity(Entity entity) {
        this.invalidateCache();
        this.cachedEntity = entity;
    }

    @Override
    public void invalidateCache() {
        if (this.cachedEntity != null) {
            this.cachedEntity.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        this.cachedEntity = null;
        this.cachedSynchronizers = null;
        this.cachedRotationSynchronizers = null;
    }
}

