/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.capabilities.common;

import de.budschie.bmorph.capabilities.common.CommonCapabilitySynchronizer;
import de.budschie.bmorph.network.MainNetworkChannel;
import java.text.MessageFormat;
import java.util.Optional;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.network.PacketDistributor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class CommonCapabilityHandler<C, P extends CommonCapabilitySynchronizer.CommonCapabilitySynchronizerPacket> {
    private Logger logger = LogManager.getLogger();
    protected Capability<C> capabilityToken;

    public CommonCapabilityHandler(Capability<C> capabilityToken) {
        this.capabilityToken = capabilityToken;
    }

    protected abstract P createPacket(Player var1, C var2);

    public Optional<P> getPacketForPlayer(Player player) {
        Optional resolvedCapability = player.getCapability(this.capabilityToken).resolve();
        if (resolvedCapability.isPresent()) {
            P packet = this.createPacket(player, resolvedCapability.get());
            ((CommonCapabilitySynchronizer.CommonCapabilitySynchronizerPacket)packet).setPlayer(player.m_142081_());
            return Optional.of(packet);
        }
        this.logger.info(MessageFormat.format("The player {0}({1}) does not have the capability {2}.", player.m_142081_(), player.m_7755_().getString(), this.capabilityToken.getName()));
        return Optional.empty();
    }

    public void synchronizeWithClient(Player toSynchronize, ServerPlayer with) {
        this.getPacketForPlayer(toSynchronize).ifPresent(packet -> MainNetworkChannel.INSTANCE.send(PacketDistributor.PLAYER.with(() -> with), packet));
    }

    public void synchronizeWithClients(Player toSynchronize) {
        this.getPacketForPlayer(toSynchronize).ifPresent(packet -> MainNetworkChannel.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> toSynchronize), packet));
    }

    public Logger getLogger() {
        return this.logger;
    }
}

