/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.capabilities.common;

import de.budschie.bmorph.network.ISimpleImplPacket;
import java.text.MessageFormat;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class CommonCapabilitySynchronizer<P extends CommonCapabilitySynchronizerPacket, C>
implements ISimpleImplPacket<P> {
    private Logger logger = LogManager.getLogger();
    private Capability<C> capabilityToken;

    public CommonCapabilitySynchronizer(Capability<C> capabilityToken) {
        this.capabilityToken = capabilityToken;
    }

    @Override
    public void encode(P packet, FriendlyByteBuf buffer) {
        buffer.m_130077_(((CommonCapabilitySynchronizerPacket)packet).getPlayer());
        this.encodeAdditional(packet, buffer);
    }

    @Override
    public P decode(FriendlyByteBuf buffer) {
        UUID player = buffer.m_130259_();
        P packet = this.decodeAdditional(buffer);
        ((CommonCapabilitySynchronizerPacket)packet).setPlayer(player);
        return packet;
    }

    @Override
    public void handle(P packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (Minecraft.m_91087_().f_91073_ == null) {
                this.logger.info("Can't process capability sync packet because level is null");
            } else {
                Player player = Minecraft.m_91087_().f_91073_.m_46003_(packet.getPlayer());
                if (player == null) {
                    this.logger.info(MessageFormat.format("Can't process capability sync packet because the player with the UUID {0} could not be found.", packet.getPlayer().toString()));
                } else {
                    Optional capabilityInterface = player.getCapability(this.capabilityToken).resolve();
                    if (capabilityInterface.isPresent()) {
                        ((NetworkEvent.Context)ctx.get()).setPacketHandled(this.handleCapabilitySync(packet, ctx, player, capabilityInterface.get()));
                    } else {
                        this.logger.info(MessageFormat.format("Can't process capability sync packet because the capability {0} was not attached to player {1}({2})", this.capabilityToken.getName(), packet.getPlayer(), player.m_7755_().getString()));
                    }
                }
            }
        });
    }

    public abstract void encodeAdditional(P var1, FriendlyByteBuf var2);

    public abstract P decodeAdditional(FriendlyByteBuf var1);

    public abstract boolean handleCapabilitySync(P var1, Supplier<NetworkEvent.Context> var2, Player var3, C var4);

    public Logger getLogger() {
        return this.logger;
    }

    public static class CommonCapabilitySynchronizerPacket {
        private UUID player;

        public UUID getPlayer() {
            return this.player;
        }

        public void setPlayer(UUID player) {
            this.player = player;
        }
    }
}

