/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.capabilities.guardian;

import de.budschie.bmorph.capabilities.guardian.IGuardianBeamCapability;
import de.budschie.bmorph.events.GuardianAbilityStatusUpdateEvent;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class GuardianBeamCapability
implements IGuardianBeamCapability {
    private Optional<UUID> attackedEntityServer = Optional.empty();
    private Optional<Integer> attackedEntity = Optional.empty();
    private int progression;
    private int maxAttackProgression;
    private Player player;

    public GuardianBeamCapability(Player player) {
        this.player = player;
    }

    @Override
    public Player getPlayer() {
        return this.player;
    }

    @Override
    public Optional<UUID> getAttackedEntityServer() {
        return this.attackedEntityServer;
    }

    @Override
    public int getAttackProgression() {
        return this.progression;
    }

    @Override
    public void setAttackedEntityServer(Optional<UUID> attackedEntity) {
        this.attackedEntityServer = attackedEntity;
    }

    @Override
    public void setAttackProgression(int progression) {
        this.progression = progression;
    }

    @Override
    public void attackServer(Optional<Entity> entity, int maxAttackDuration) {
        if (this.attackedEntityServer.isPresent() && entity.isEmpty()) {
            MinecraftForge.EVENT_BUS.post((Event)new GuardianAbilityStatusUpdateEvent(this.player, this, true));
        }
        this.setAttackedEntityServer(entity.map(entityInstance -> entityInstance.m_142081_()));
        this.attack(entity.map(entityInstance -> entityInstance.m_142049_()), maxAttackDuration);
    }

    @Override
    public Optional<Integer> getAttackedEntity() {
        return this.attackedEntity;
    }

    @Override
    public void setAttackedEntity(Optional<Integer> attackedEntity) {
        this.attackedEntity = attackedEntity;
    }

    @Override
    public void attack(Optional<Integer> entity, int maxAttackDuration) {
        this.setAttackedEntity(entity);
        this.setAttackProgression(0);
        this.setMaxAttackProgression(maxAttackDuration);
    }

    @Override
    public int getMaxAttackProgression() {
        return this.maxAttackProgression;
    }

    @Override
    public void setMaxAttackProgression(int maxAttackProgression) {
        this.maxAttackProgression = maxAttackProgression;
    }
}

