/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.capabilities.guardian;

import de.budschie.bmorph.capabilities.common.CommonCapabilityHandler;
import de.budschie.bmorph.capabilities.guardian.GuardianBeamCapabilityInstance;
import de.budschie.bmorph.capabilities.guardian.IGuardianBeamCapability;
import de.budschie.bmorph.events.GuardianAbilityStatusUpdateEvent;
import de.budschie.bmorph.network.GuardianBeamAttack;
import java.util.Optional;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class GuardianBeamCapabilityHandler
extends CommonCapabilityHandler<IGuardianBeamCapability, GuardianBeamAttack.GuardianBeamAttackPacket> {
    public static final GuardianBeamCapabilityHandler INSTANCE = new GuardianBeamCapabilityHandler();

    public GuardianBeamCapabilityHandler() {
        super(GuardianBeamCapabilityInstance.GUARDIAN_BEAM_CAP);
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            event.player.getCapability(GuardianBeamCapabilityInstance.GUARDIAN_BEAM_CAP).ifPresent(cap -> {
                if (cap.getAttackedEntity().isPresent()) {
                    cap.setAttackProgression(cap.getAttackProgression() + 1);
                    MinecraftForge.EVENT_BUS.post((Event)new GuardianAbilityStatusUpdateEvent(event.player, (IGuardianBeamCapability)cap, false));
                }
            });
        }
    }

    public void attackServer(Player player, Entity toAttack, int maxAttackDuration) {
        player.getCapability(GuardianBeamCapabilityInstance.GUARDIAN_BEAM_CAP).ifPresent(cap -> {
            cap.attackServer(Optional.of(toAttack), maxAttackDuration);
            this.synchronizeWithClients(player);
        });
    }

    public void unattackServer(Player player) {
        player.getCapability(GuardianBeamCapabilityInstance.GUARDIAN_BEAM_CAP).ifPresent(cap -> {
            cap.attackServer(Optional.empty(), 0);
            this.synchronizeWithClients(player);
        });
    }

    private static void validateEntity(Player player, IGuardianBeamCapability cap) {
        if (cap.shouldRecalculateEntityId()) {
            Entity entity = ((ServerLevel)player.f_19853_).m_8791_(cap.getAttackedEntityServer().get());
            if (entity == null) {
                cap.attackServer(Optional.empty(), 0);
                MinecraftForge.EVENT_BUS.post((Event)new GuardianAbilityStatusUpdateEvent(player, cap, true));
            } else {
                cap.setAttackedEntity(Optional.of(entity.m_142049_()));
            }
        }
    }

    @Override
    protected GuardianBeamAttack.GuardianBeamAttackPacket createPacket(Player player, IGuardianBeamCapability capability) {
        GuardianBeamCapabilityHandler.validateEntity(player, capability);
        return new GuardianBeamAttack.GuardianBeamAttackPacket(capability.getAttackedEntity(), capability.getAttackProgression(), capability.getMaxAttackProgression());
    }
}

