/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.capabilities.guardian;

import de.budschie.bmorph.capabilities.common.CommonCapabilityInstanceSerializable;
import de.budschie.bmorph.capabilities.guardian.GuardianBeamCapability;
import de.budschie.bmorph.capabilities.guardian.IGuardianBeamCapability;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class GuardianBeamCapabilityInstance
extends CommonCapabilityInstanceSerializable<IGuardianBeamCapability> {
    public static final ResourceLocation CAPABILITY_NAME = new ResourceLocation("bmorph", "guardian_beam_cap");
    public static final Capability<IGuardianBeamCapability> GUARDIAN_BEAM_CAP = CapabilityManager.get((CapabilityToken)new CapabilityToken<IGuardianBeamCapability>(){});

    public GuardianBeamCapabilityInstance(Player player) {
        super(CAPABILITY_NAME, GUARDIAN_BEAM_CAP, () -> new GuardianBeamCapability(player));
    }

    @SubscribeEvent
    public static void onAttachCapsOnPlayer(AttachCapabilitiesEvent<Entity> event) {
        Object object = event.getObject();
        if (object instanceof Player) {
            Player player = (Player)object;
            event.addCapability(CAPABILITY_NAME, (ICapabilityProvider)new GuardianBeamCapabilityInstance(player));
        }
    }

    @Override
    public void deserializeAdditional(CompoundTag tag, IGuardianBeamCapability instance) {
        if (tag.m_128441_("attacked_entity")) {
            instance.setAttackedEntityServer(Optional.of(tag.m_128342_("attacked_entity")));
        }
        instance.setAttackProgression(tag.m_128451_("attack_progression"));
    }

    @Override
    public void serializeAdditional(CompoundTag tag, IGuardianBeamCapability instance) {
        instance.getAttackedEntityServer().ifPresent(uuid -> tag.m_128362_("attacked_entity", uuid));
        tag.m_128405_("attack_progression", instance.getAttackProgression());
    }
}

