/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.capabilities.phantom_glide;

import de.budschie.bmorph.capabilities.common.CommonCapabilityHandler;
import de.budschie.bmorph.capabilities.phantom_glide.ChargeDirection;
import de.budschie.bmorph.capabilities.phantom_glide.GlideCapabilityInstance;
import de.budschie.bmorph.capabilities.phantom_glide.GlideStatus;
import de.budschie.bmorph.capabilities.phantom_glide.IGlideCapability;
import de.budschie.bmorph.network.GlideStatusChange;
import java.util.function.Consumer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class GlideCapabilityHandler
extends CommonCapabilityHandler<IGlideCapability, GlideStatusChange.GlideStatusChangePacket> {
    public static final GlideCapabilityHandler INSTANCE = new GlideCapabilityHandler();

    public GlideCapabilityHandler() {
        super(GlideCapabilityInstance.GLIDE_CAP);
    }

    private void changeStatusServer(Player player, Consumer<IGlideCapability> consumer) {
        player.getCapability(GlideCapabilityInstance.GLIDE_CAP).ifPresent(cap -> {
            consumer.accept((IGlideCapability)cap);
            this.synchronizeWithClients(player);
        });
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            event.player.getCapability(GlideCapabilityInstance.GLIDE_CAP).ifPresent(cap -> {
                if (cap.getGlideStatus() == GlideStatus.CHARGE_TRANSITION_IN) {
                    cap.setTransitionTime(cap.getTransitionTime() - 1);
                    if (cap.getTransitionTime() <= 0) {
                        cap.setTransitionTime(cap.getMaxTransitionTime());
                        cap.setGlideStatus(GlideStatus.CHARGE, event.player);
                    }
                } else if (cap.getGlideStatus() == GlideStatus.CHARGE) {
                    cap.setChargeTime(cap.getChargeTime() - 1);
                    if (cap.getChargeTime() <= 0) {
                        cap.setGlideStatus(GlideStatus.CHARGE_TRANSITION_OUT, event.player);
                    }
                } else if (cap.getGlideStatus() == GlideStatus.CHARGE_TRANSITION_OUT) {
                    cap.setTransitionTime(cap.getTransitionTime() - 1);
                    if (cap.getTransitionTime() <= 0) {
                        cap.setGlideStatus(GlideStatus.GLIDE, event.player);
                    }
                }
            });
        }
    }

    public void glideServer(Player player) {
        this.changeStatusServer(player, glide -> glide.glide(player));
    }

    public void chargeServer(Player player, int maxChargeTime, ChargeDirection direction) {
        this.changeStatusServer(player, charge -> charge.charge(maxChargeTime, direction, player));
    }

    public void startChargingServer(Player player, int transitionTime, int maxChargeTime, ChargeDirection direction) {
        this.changeStatusServer(player, transitionIn -> transitionIn.transitionIn(transitionTime, maxChargeTime, direction, player));
    }

    public void stopChargingServer(Player player) {
        this.changeStatusServer(player, transitionOut -> transitionOut.transitionOut(player));
    }

    public void standardServer(Player player) {
        this.changeStatusServer(player, standard -> standard.standard(player));
    }

    @Override
    protected GlideStatusChange.GlideStatusChangePacket createPacket(Player player, IGlideCapability capability) {
        return new GlideStatusChange.GlideStatusChangePacket(capability.getGlideStatus(), capability.getChargeTime(), capability.getMaxChargeTime(), capability.getTransitionTime(), capability.getChargeDirection());
    }
}

