/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.capabilities.phantom_glide;

import de.budschie.bmorph.capabilities.common.CommonCapabilityInstanceSerializable;
import de.budschie.bmorph.capabilities.phantom_glide.ChargeDirection;
import de.budschie.bmorph.capabilities.phantom_glide.GlideCapability;
import de.budschie.bmorph.capabilities.phantom_glide.GlideStatus;
import de.budschie.bmorph.capabilities.phantom_glide.IGlideCapability;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class GlideCapabilityInstance
extends CommonCapabilityInstanceSerializable<IGlideCapability> {
    public static final ResourceLocation CAPABILITY_NAME = new ResourceLocation("bmorph", "glide_cap");
    public static final Capability<IGlideCapability> GLIDE_CAP = CapabilityManager.get((CapabilityToken)new CapabilityToken<IGlideCapability>(){});

    public GlideCapabilityInstance() {
        super(CAPABILITY_NAME, GLIDE_CAP, GlideCapability::new);
    }

    @SubscribeEvent
    public static void onAttachCapsOnPlayer(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player) {
            event.addCapability(CAPABILITY_NAME, (ICapabilityProvider)new GlideCapabilityInstance());
        }
    }

    @Override
    public void deserializeAdditional(CompoundTag tag, IGlideCapability instance) {
        instance.setGlideStatus(GlideStatus.valueOf(tag.m_128461_("glide")), null);
        instance.setChargeTime(tag.m_128451_("chargeTime"));
        instance.setMaxChargeTime(tag.m_128451_("maxChargeTime"));
        instance.setTransitionTime(tag.m_128451_("transitionTime"));
        if (instance.getGlideStatus() == GlideStatus.CHARGE) {
            instance.setChargeDirection(ChargeDirection.valueOf(tag.m_128461_("chargeDirection")));
        }
    }

    @Override
    public void serializeAdditional(CompoundTag tag, IGlideCapability instance) {
        tag.m_128359_("glide", instance.getGlideStatus().name());
        tag.m_128405_("chargeTime", instance.getChargeTime());
        tag.m_128405_("maxChargeTime", instance.getMaxChargeTime());
        tag.m_128405_("transitionTime", instance.getTransitionTime());
        if (instance.getGlideStatus() == GlideStatus.CHARGE && instance.getChargeDirection() != null) {
            tag.m_128359_("chargeDirection", instance.getChargeDirection().name());
        }
    }
}

