/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.capabilities.phantom_glide;

import de.budschie.bmorph.capabilities.phantom_glide.ChargeDirection;
import de.budschie.bmorph.capabilities.phantom_glide.GlideStatus;
import net.minecraft.world.entity.player.Player;

public interface IGlideCapability {
    public GlideStatus getGlideStatus();

    public void setGlideStatus(GlideStatus var1, Player var2);

    public int getChargeTime();

    public void setChargeTime(int var1);

    public int getMaxChargeTime();

    public void setMaxChargeTime(int var1);

    public int getTransitionTime();

    public void setTransitionTime(int var1);

    public int getMaxTransitionTime();

    public void setMaxTransitionTime(int var1);

    public ChargeDirection getChargeDirection();

    public void setChargeDirection(ChargeDirection var1);

    default public void glide(Player player) {
        this.setGlideStatus(GlideStatus.GLIDE, player);
        this.setChargeDirection(null);
    }

    default public void standard(Player player) {
        this.setGlideStatus(GlideStatus.STANDARD, player);
        this.setChargeDirection(null);
    }

    default public void charge(int maxChargeTime, ChargeDirection direction, Player player) {
        this.setGlideStatus(GlideStatus.CHARGE, player);
        this.setChargeTime(maxChargeTime);
        this.setMaxChargeTime(maxChargeTime);
        this.setChargeDirection(direction);
    }

    default public void transitionIn(int transitionTime, int maxChargeTime, ChargeDirection direction, Player player) {
        this.setGlideStatus(GlideStatus.CHARGE_TRANSITION_IN, player);
        this.setChargeTime(maxChargeTime);
        this.setMaxChargeTime(maxChargeTime);
        this.setChargeDirection(direction);
        this.setTransitionTime(transitionTime);
        this.setMaxTransitionTime(transitionTime);
    }

    default public void transitionOut(Player player) {
        this.setGlideStatus(GlideStatus.CHARGE_TRANSITION_OUT, player);
    }
}

