/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.capabilities.pufferfish;

import de.budschie.bmorph.capabilities.common.CommonCapabilityHandler;
import de.budschie.bmorph.capabilities.pufferfish.IPufferfishCapability;
import de.budschie.bmorph.capabilities.pufferfish.PufferfishCapabilityInstance;
import de.budschie.bmorph.network.PufferfishPuff;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class PufferfishCapabilityHandler
extends CommonCapabilityHandler<IPufferfishCapability, PufferfishPuff.PufferfishPuffPacket> {
    public static final PufferfishCapabilityHandler INSTANCE = new PufferfishCapabilityHandler();

    public PufferfishCapabilityHandler() {
        super(PufferfishCapabilityInstance.PUFFER_CAP);
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            event.player.getCapability(PufferfishCapabilityInstance.PUFFER_CAP).ifPresent(cap -> {
                if (cap.getPuffTime() > 0) {
                    cap.setPuffTime(cap.getPuffTime() - 1);
                }
            });
        }
    }

    public void puffServer(Player player, int duration) {
        player.getCapability(PufferfishCapabilityInstance.PUFFER_CAP).ifPresent(cap -> {
            cap.puff(duration);
            this.synchronizeWithClients(player);
        });
    }

    @Override
    protected PufferfishPuff.PufferfishPuffPacket createPacket(Player player, IPufferfishCapability capability) {
        return new PufferfishPuff.PufferfishPuffPacket(capability.getOriginalPuffTime(), capability.getPuffTime());
    }
}

