/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import de.budschie.bmorph.capabilities.blacklist.BlacklistData;
import de.budschie.bmorph.capabilities.blacklist.ConfigManager;
import de.budschie.bmorph.commands.RemovableSuggestionProvider;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntitySummonArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.synchronization.SuggestionProviders;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;

public class BlacklistCommand {
    public static void registerCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"morphblacklist").requires(src -> src.m_6761_(2))).then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"entity", (ArgumentType)EntitySummonArgument.m_93335_()).suggests(SuggestionProviders.f_121645_).executes(BlacklistCommand::addBlacklist)))).then(Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"entity", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests((SuggestionProvider)RemovableSuggestionProvider.INSTANCE).executes(BlacklistCommand::removeBlacklist)))).then(Commands.m_82127_((String)"list").executes(BlacklistCommand::listBlacklist)));
    }

    private static int addBlacklist(CommandContext<CommandSourceStack> ctx) {
        ResourceLocation arg;
        BlacklistData blacklist = ConfigManager.INSTANCE.get(BlacklistData.class);
        if (blacklist.isInBlacklist(arg = (ResourceLocation)ctx.getArgument("entity", ResourceLocation.class))) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)new TextComponent("Failed to add entry " + arg.toString() + " to the entity blacklist because that entry already exists."));
        } else {
            blacklist.addBlacklist(arg);
            ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TextComponent(ChatFormatting.GREEN + "Successfully added " + arg.toString() + " to the blacklist!"), true);
            blacklist.writeToFile();
        }
        return 0;
    }

    private static int listBlacklist(CommandContext<CommandSourceStack> ctx) {
        BlacklistData blacklist = ConfigManager.INSTANCE.get(BlacklistData.class);
        String conc = String.join((CharSequence)", ", (CharSequence[])blacklist.getBlacklist().stream().map(rs -> rs.toString()).toArray(String[]::new));
        StringBuilder builder = new StringBuilder();
        builder.append(ChatFormatting.GREEN);
        boolean isSingular = blacklist.getBlacklist().size() == 1;
        builder.append("There ").append(isSingular ? "is" : "are").append(" currently ").append(blacklist.getBlacklist().size()).append(isSingular ? " entry" : " entries").append(" in the blacklist: ").append(conc);
        ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TextComponent(builder.toString()), false);
        return 0;
    }

    private static int removeBlacklist(CommandContext<CommandSourceStack> ctx) {
        ResourceLocation arg = (ResourceLocation)ctx.getArgument("entity", ResourceLocation.class);
        BlacklistData blacklist = ConfigManager.INSTANCE.get(BlacklistData.class);
        if (blacklist.isInBlacklist(arg)) {
            blacklist.removeBlacklist(arg);
            ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TextComponent(ChatFormatting.GREEN + "Successfully removed " + arg.toString() + " from the entity blacklist."), false);
            blacklist.writeToFile();
        } else {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)new TextComponent("Failed to remove entry " + arg.toString() + " from the entity blacklist because that entry doesn't exist yet."));
        }
        return 0;
    }
}

