/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.commands;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.budschie.bmorph.capabilities.IMorphCapability;
import de.budschie.bmorph.capabilities.MorphCapabilityAttacher;
import de.budschie.bmorph.main.ServerSetup;
import de.budschie.bmorph.morph.MorphItem;
import de.budschie.bmorph.morph.MorphManagerHandlers;
import de.budschie.bmorph.morph.MorphUtil;
import de.budschie.bmorph.morph.fallback.FallbackMorphItem;
import de.budschie.bmorph.morph.functionality.Ability;
import de.budschie.bmorph.network.MainNetworkChannel;
import de.budschie.bmorph.network.MorphItemDisabled;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.text.MessageFormat;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiFunction;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.CompoundTagArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.EntitySummonArgument;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.commands.synchronization.SuggestionProviders;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;

public class MorphCommand {
    public static void registerCommands(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"morph").requires(sender -> sender.m_6761_(2))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91470_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"entity", (ArgumentType)EntitySummonArgument.m_93335_()).suggests(SuggestionProviders.f_121645_).executes(ctx -> MorphCommand.createEntityMorph(((EntitySelector)ctx.getArgument("player", EntitySelector.class)).m_121166_((CommandSourceStack)ctx.getSource()), (ResourceLocation)ctx.getArgument("entity", ResourceLocation.class), new CompoundTag()))).then(Commands.m_82129_((String)"nbt", (ArgumentType)CompoundTagArgument.m_87657_()).executes(ctx -> MorphCommand.createEntityMorph(((EntitySelector)ctx.getArgument("player", EntitySelector.class)).m_121166_((CommandSourceStack)ctx.getSource()), (ResourceLocation)ctx.getArgument("entity", ResourceLocation.class), (CompoundTag)ctx.getArgument("nbt", CompoundTag.class)))))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"morphplayer").requires(sender -> sender.m_6761_(2))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"playername", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            List players = ((EntitySelector)ctx.getArgument("player", EntitySelector.class)).m_121166_((CommandSourceStack)ctx.getSource());
            for (ServerPlayer player : players) {
                Optional gp = ServerSetup.server.m_129927_().m_10996_((String)ctx.getArgument("playername", String.class));
                if (gp.isPresent()) {
                    MorphUtil.morphToServer(Optional.of(MorphManagerHandlers.PLAYER.createMorph(EntityType.f_20532_, (GameProfile)gp.get())), Optional.empty(), (Player)player);
                    continue;
                }
                ((CommandSourceStack)ctx.getSource()).m_81352_((Component)new TextComponent(ChatFormatting.RED + "The player " + (String)ctx.getArgument("playername", String.class) + " doesn't exist."));
            }
            return 0;
        }))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"demorph").requires(sender -> sender.m_6761_(2))).executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
            MorphUtil.morphToServer(Optional.empty(), Optional.empty(), (Player)player);
            return 0;
        })).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91470_()).executes(ctx -> {
            List players = ((EntitySelector)ctx.getArgument("player", EntitySelector.class)).m_121166_((CommandSourceStack)ctx.getSource());
            for (ServerPlayer player : players) {
                MorphUtil.morphToServer(Optional.empty(), Optional.empty(), (Player)player);
            }
            return 0;
        })));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"addmorph").requires(sender -> sender.m_6761_(2))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91470_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"entity", (ArgumentType)EntitySummonArgument.m_93335_()).suggests(SuggestionProviders.f_121645_).executes(ctx -> MorphCommand.addMorph(((EntitySelector)ctx.getArgument("player", EntitySelector.class)).m_121166_((CommandSourceStack)ctx.getSource()), (ResourceLocation)ctx.getArgument("entity", ResourceLocation.class), new CompoundTag()))).then(Commands.m_82129_((String)"nbt", (ArgumentType)CompoundTagArgument.m_87657_()).executes(ctx -> MorphCommand.addMorph(((EntitySelector)ctx.getArgument("player", EntitySelector.class)).m_121166_((CommandSourceStack)ctx.getSource()), (ResourceLocation)ctx.getArgument("entity", ResourceLocation.class), (CompoundTag)ctx.getArgument("nbt", CompoundTag.class)))))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"disable_morph_item").requires(sender -> sender.m_6761_(2))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91470_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"disabled_for", (ArgumentType)IntegerArgumentType.integer((int)0)).then(Commands.m_82127_((String)"current_morph_item").executes(ctx -> MorphCommand.disableMorphItems((CommandContext<CommandSourceStack>)ctx, (sp, cap) -> {
            if (cap.getCurrentMorphIndex().isPresent()) {
                return new int[]{cap.getCurrentMorphIndex().get()};
            }
            return null;
        })))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"everything").then(Commands.m_82127_((String)"matching").then(Commands.m_82127_((String)"entity_type").then(Commands.m_82129_((String)"entity_type", (ArgumentType)EntitySummonArgument.m_93335_()).suggests(SuggestionProviders.f_121645_).executes(ctx -> MorphCommand.disableMorphItems((CommandContext<CommandSourceStack>)ctx, (sp, cap) -> {
            EntityType desiredEntityType = (EntityType)ForgeRegistries.ENTITIES.getValue((ResourceLocation)ctx.getArgument("entity_type", ResourceLocation.class));
            if (desiredEntityType == null) {
                return null;
            }
            IntArrayList intArrayList = new IntArrayList();
            for (int i = 0; i < cap.getMorphList().getMorphArrayList().size(); ++i) {
                MorphItem currentItem = cap.getMorphList().getMorphArrayList().get(i);
                if (currentItem.getEntityType() != desiredEntityType) continue;
                intArrayList.add(i);
            }
            return intArrayList.toIntArray();
        })))))).executes(ctx -> MorphCommand.disableMorphItems((CommandContext<CommandSourceStack>)ctx, (sp, cap) -> {
            int[] toDisable = new int[cap.getMorphList().getMorphArrayList().size()];
            for (int i = 0; i < toDisable.length; ++i) {
                toDisable[i] = i;
            }
            return toDisable;
        }))))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"morph_list_ability").requires(sender -> sender.m_6761_(2))).executes(ctx -> MorphCommand.listAbilities((CommandSourceStack)ctx.getSource(), (Player)((CommandSourceStack)ctx.getSource()).m_81375_()))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(ctx -> MorphCommand.listAbilities((CommandSourceStack)ctx.getSource(), (Player)EntityArgument.m_91474_((CommandContext)ctx, (String)"player")))));
    }

    private static int disableMorphItems(CommandContext<CommandSourceStack> ctx, BiFunction<ServerPlayer, IMorphCapability, int[]> morphItemSelectionFunction) throws CommandSyntaxException {
        List players = ((EntitySelector)ctx.getArgument("player", EntitySelector.class)).m_121166_((CommandSourceStack)ctx.getSource());
        int disableFor = (Integer)ctx.getArgument("disabled_for", Integer.class);
        int succeeded = 0;
        for (ServerPlayer player : players) {
            int[] selectedMorphs;
            IMorphCapability cap = MorphUtil.getCapOrNull((Player)player);
            if (cap == null || (selectedMorphs = morphItemSelectionFunction.apply(player, cap)) == null || selectedMorphs.length <= 0) continue;
            for (int i : selectedMorphs) {
                cap.getMorphList().getMorphArrayList().get(i).disable(disableFor);
            }
            MorphItemDisabled.MorphItemDisabledPacket packet = new MorphItemDisabled.MorphItemDisabledPacket(disableFor, selectedMorphs);
            MainNetworkChannel.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)packet);
            ++succeeded;
        }
        ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TextComponent(MessageFormat.format("{0}/{1} players' morphs were successfully disabled.", succeeded, players.size())), false);
        return 0;
    }

    private static int listAbilities(CommandSourceStack sender, Player player) {
        IMorphCapability cap = MorphUtil.getCapOrNull(player);
        if (cap == null || !cap.getCurrentMorph().isPresent()) {
            sender.m_81352_((Component)new TextComponent("The given player is currently not morphed."));
        } else if (cap.getCurrentAbilities().size() <= 0) {
            sender.m_81354_((Component)new TextComponent(ChatFormatting.AQUA + "The given player has no abilities, but they are morphed."), true);
        } else {
            StringBuilder builder = new StringBuilder(ChatFormatting.GREEN + "The given player currently has following abilities: ").append(ChatFormatting.WHITE);
            for (int i = 0; i < cap.getCurrentAbilities().size(); ++i) {
                Ability currentAbility = cap.getCurrentAbilities().get(i);
                builder.append(currentAbility.getResourceLocation().toString()).append('(').append(currentAbility.getConfigurableAbility().getRegistryName().toString()).append(')');
                if (i == cap.getCurrentAbilities().size() - 2) {
                    builder.append(" and ");
                    continue;
                }
                if (i == cap.getCurrentAbilities().size() - 1) continue;
                builder.append(", ");
            }
            sender.m_81354_((Component)new TextComponent(builder.toString()), true);
        }
        return 0;
    }

    private static int addMorph(List<ServerPlayer> entities, ResourceLocation rs, CompoundTag nbtData) {
        FallbackMorphItem morphItemToAdd = MorphManagerHandlers.FALLBACK.createMorph((EntityType)ForgeRegistries.ENTITIES.getValue(rs), nbtData, null, true);
        for (ServerPlayer entity : entities) {
            IMorphCapability capability = (IMorphCapability)entity.getCapability(MorphCapabilityAttacher.MORPH_CAP).resolve().get();
            if (capability.getMorphList().contains(morphItemToAdd)) {
                entity.m_6352_((Component)new TextComponent(ChatFormatting.RED + "You may not add a morph to your list that is already present."), new UUID(0L, 0L));
                continue;
            }
            entity.m_6352_((Component)new TextComponent("Added " + rs.toString() + " with its NBT data to your morph list."), new UUID(0L, 0L));
            capability.addToMorphList(morphItemToAdd);
            capability.syncMorphAcquisition(morphItemToAdd);
        }
        return 0;
    }

    private static int createEntityMorph(List<ServerPlayer> entities, ResourceLocation rs, CompoundTag nbtData) {
        for (ServerPlayer entity : entities) {
            if (rs.toString().equals("bmorph:morph_entity")) {
                throw new IllegalArgumentException("You may not morph yourself into the morph entity.");
            }
            nbtData.m_128359_("id", rs.toString());
            MorphUtil.morphToServer(Optional.of(MorphManagerHandlers.FALLBACK.createMorph((EntityType)ForgeRegistries.ENTITIES.getValue(rs), nbtData, null, true)), Optional.empty(), (Player)entity);
        }
        return 0;
    }
}

