/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.datagen;

import de.budschie.bmorph.datagen.nbt_handlers.NBTHandlerProvider;
import de.budschie.bmorph.json_integration.JsonMorphNBTHandler;
import de.budschie.bmorph.json_integration.NBTPath;
import de.budschie.bmorph.morph.functionality.data_transformers.DataTransformer;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.data.DataProvider;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, modid="bmorph")
public class DataGeneratorHandler {
    @SubscribeEvent
    public static void onGatheringData(GatherDataEvent event) {
        if (event.includeServer()) {
            NBTHandlerProvider nbtHandlerProvider = new NBTHandlerProvider(event.getGenerator());
            DataGeneratorHandler.registerNBTHandlerProviders(nbtHandlerProvider);
            event.getGenerator().m_123914_((DataProvider)nbtHandlerProvider);
        }
    }

    private static void registerNBTHandlerProviders(NBTHandlerProvider provider) {
        List entityTypes = ForgeRegistries.ENTITIES.getValues().parallelStream().filter(entityType -> entityType.getRegistryName().m_135827_().equals("betteranimalsplus")).filter(entityType -> {
            String entity = entityType.getRegistryName().m_135815_();
            return !entity.equals("golden_goose_egg") && !entity.equals("goose_egg") && !entity.equals("turkey_egg") && !entity.equals("pheasant_egg");
        }).collect(Collectors.toList());
        for (EntityType entityType2 : entityTypes) {
            provider.addData(entityType2, new JsonMorphNBTHandler(new CompoundTag(), new NBTPath[]{new NBTPath("VariantId")}, new ArrayList<LazyOptional<DataTransformer>>()));
        }
    }
}

