/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.datagen.nbt_handlers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.budschie.bmorph.json_integration.JsonMorphNBTHandler;
import de.budschie.bmorph.json_integration.NBTPath;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.world.entity.EntityType;

public class NBTHandlerProvider
implements DataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private HashMap<EntityType<?>, JsonMorphNBTHandler> data = new HashMap();
    private DataGenerator generator;

    public NBTHandlerProvider(DataGenerator generator) {
        this.generator = generator;
    }

    public void m_6865_(HashCache cache) throws IOException {
        for (Map.Entry<EntityType<?>, JsonMorphNBTHandler> entry : this.data.entrySet()) {
            DataProvider.m_123920_((Gson)GSON, (HashCache)cache, (JsonElement)this.serializeJsonMorphNBTHandler(entry.getKey(), entry.getValue()), (Path)this.generator.m_123916_().resolve(FileSystems.getDefault().getPath("data", entry.getKey().getRegistryName().m_135827_(), "morph_nbt", entry.getKey().getRegistryName().m_135815_() + ".json")));
        }
    }

    private JsonElement serializeJsonMorphNBTHandler(EntityType<?> type, JsonMorphNBTHandler nbtHandler) {
        JsonObject root = new JsonObject();
        root.addProperty("entity_type", type.getRegistryName().toString());
        JsonArray trackedNbtJSON = new JsonArray();
        for (NBTPath nbtPath : nbtHandler.getTrackedNbt()) {
            trackedNbtJSON.add(nbtPath.toString());
        }
        root.add("tracked_nbt_keys", (JsonElement)trackedNbtJSON);
        root.addProperty("default_nbt", nbtHandler.getDefaultNbt().m_7916_());
        return root;
    }

    public void addData(EntityType<?> entityType, JsonMorphNBTHandler nbtHandler) {
        this.data.put(entityType, nbtHandler);
    }

    public String m_6055_() {
        return "Morph NBT Handlers";
    }
}

