/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.entity;

import com.mojang.authlib.GameProfile;
import de.budschie.bmorph.capabilities.IMorphCapability;
import de.budschie.bmorph.capabilities.MorphCapabilityAttacher;
import de.budschie.bmorph.entity.EntityRegistry;
import de.budschie.bmorph.events.AcquiredMorphEvent;
import de.budschie.bmorph.morph.MorphHandler;
import de.budschie.bmorph.morph.MorphItem;
import de.budschie.bmorph.morph.MorphManagerHandlers;
import de.budschie.bmorph.morph.player.PlayerMorphItem;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.DataSerializerEntry;

public class MorphEntity
extends Entity {
    private static final PlayerMorphItem DEFAULT = MorphManagerHandlers.PLAYER.createMorph(EntityType.f_20532_, new GameProfile(new UUID(0L, 0L), "SteveMcSteve"));
    private static final EntityDataAccessor<MorphItem> MORPH_ITEM = SynchedEntityData.m_135353_(MorphEntity.class, (EntityDataSerializer)((DataSerializerEntry)EntityRegistry.MORPH_SERIALIZER.get()).getSerializer());
    private static final EntityDataAccessor<Integer> PICKUP_POSSIBLE_IN = SynchedEntityData.m_135353_(MorphEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public MorphEntity(EntityType<?> type, Level world) {
        super(type, world);
    }

    public MorphEntity(Level world, MorphItem morphItem) {
        this(world, morphItem, 0);
    }

    public MorphEntity(Level world, MorphItem morphItem, int pickupPossibleIn) {
        super((EntityType)EntityRegistry.MORPH_ENTITY.get(), world);
        this.m_20088_().m_135381_(MORPH_ITEM, (Object)morphItem);
        this.m_20088_().m_135381_(PICKUP_POSSIBLE_IN, (Object)pickupPossibleIn);
    }

    public void m_8119_() {
        int pTime;
        boolean pickupPossible;
        super.m_8119_();
        if (this.f_19797_ > 6000) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        boolean bl = pickupPossible = (pTime = ((Integer)this.f_19804_.m_135370_(PICKUP_POSSIBLE_IN)).intValue()) <= 0;
        if (!this.m_20096_()) {
            this.m_20334_(this.m_20184_().f_82479_, this.m_20184_().f_82480_ - (double)0.04f, this.m_20184_().f_82481_);
        }
        if (!this.f_19861_ || this.m_20184_().m_165925_() > (double)1.0E-5f || (this.f_19797_ + this.m_142049_()) % 4 == 0) {
            this.m_6478_(MoverType.SELF, this.m_20184_());
        }
        if (pickupPossible) {
            if (!this.f_19853_.f_46443_) {
                List list = this.f_19853_.m_45933_((Entity)this, this.m_142469_());
                for (Entity entity : list) {
                    AcquiredMorphEvent.Pre acquiredMorphPre;
                    if (!(entity instanceof Player)) continue;
                    Player player = (Player)entity;
                    LazyOptional lazyCaps = player.getCapability(MorphCapabilityAttacher.MORPH_CAP);
                    if (this.f_19853_.f_46443_ || !lazyCaps.isPresent()) continue;
                    IMorphCapability resolvedCaps = (IMorphCapability)lazyCaps.resolve().get();
                    if (!((MorphItem)this.f_19804_.m_135370_(MORPH_ITEM)).isAllowedToPickUp(player) || resolvedCaps.getMorphList().contains(this.getMorphItem()) || MinecraftForge.EVENT_BUS.post((Event)(acquiredMorphPre = new AcquiredMorphEvent.Pre(player, resolvedCaps, this.getMorphItem())))) continue;
                    resolvedCaps.getMorphList().addToMorphList(this.getMorphItem());
                    resolvedCaps.syncMorphAcquisition(this.getMorphItem());
                    this.m_142687_(Entity.RemovalReason.DISCARDED);
                    this.f_19853_.m_5594_(null, this.m_142538_(), SoundEvents.f_12019_, SoundSource.AMBIENT, 2.0f, this.f_19796_.nextFloat() - 0.5f + 1.0f);
                    AcquiredMorphEvent.Post acquiredMorphEventPost = new AcquiredMorphEvent.Post(player, resolvedCaps, this.getMorphItem());
                    MinecraftForge.EVENT_BUS.post((Event)acquiredMorphEventPost);
                }
            }
        } else {
            this.f_19804_.m_135381_(PICKUP_POSSIBLE_IN, (Object)(pTime - 1));
        }
    }

    protected void m_20314_(double x, double y, double z) {
        BlockPos blockpos = new BlockPos(x, y, z);
        Vec3 vector3d = new Vec3(x - (double)blockpos.m_123341_(), y - (double)blockpos.m_123342_(), z - (double)blockpos.m_123343_());
        BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos();
        Direction direction = Direction.UP;
        double d0 = Double.MAX_VALUE;
        for (Direction direction1 : new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST, Direction.UP}) {
            double d2;
            blockpos$mutable.m_122159_((Vec3i)blockpos, direction1);
            if (this.f_19853_.m_8055_((BlockPos)blockpos$mutable).m_60838_((BlockGetter)this.f_19853_, (BlockPos)blockpos$mutable)) continue;
            double d1 = vector3d.m_82507_(direction1.m_122434_());
            double d = d2 = direction1.m_122421_() == Direction.AxisDirection.POSITIVE ? 1.0 - d1 : d1;
            if (!(d2 < d0)) continue;
            d0 = d2;
            direction = direction1;
        }
        float f = this.f_19796_.nextFloat() * 0.2f + 0.1f;
        float f1 = direction.m_122421_().m_122540_();
        Vec3 vector3d1 = this.m_20184_().m_82490_(0.75);
        if (direction.m_122434_() == Direction.Axis.X) {
            this.m_20334_(f1 * f, vector3d1.f_82480_, vector3d1.f_82481_);
        } else if (direction.m_122434_() == Direction.Axis.Y) {
            this.m_20334_(vector3d1.f_82479_, f1 * f, vector3d1.f_82481_);
        } else if (direction.m_122434_() == Direction.Axis.Z) {
            this.m_20334_(vector3d1.f_82479_, vector3d1.f_82480_, f1 * f);
        }
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(MORPH_ITEM, (Object)DEFAULT);
        this.f_19804_.m_135372_(PICKUP_POSSIBLE_IN, (Object)0);
    }

    protected void m_7378_(CompoundTag nbt) {
        this.f_19804_.m_135381_(MORPH_ITEM, (Object)MorphHandler.deserializeMorphItem(nbt.m_128469_("MorphData")));
        if (nbt.m_128441_("pickup_possible_in")) {
            this.f_19804_.m_135381_(PICKUP_POSSIBLE_IN, (Object)nbt.m_128451_("pickup_possible_in"));
        }
    }

    protected void m_7380_(CompoundTag nbt) {
        nbt.m_128365_("MorphData", (Tag)((MorphItem)this.f_19804_.m_135370_(MORPH_ITEM)).serialize());
        nbt.m_128405_("pickup_possible_in", ((Integer)this.f_19804_.m_135370_(PICKUP_POSSIBLE_IN)).intValue());
    }

    public MorphItem getMorphItem() {
        return (MorphItem)this.f_19804_.m_135370_(MORPH_ITEM);
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean m_20145_() {
        return false;
    }
}

