/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.events;

import de.budschie.bmorph.api_interact.ShrinkAPIInteractor;
import de.budschie.bmorph.capabilities.IMorphCapability;
import de.budschie.bmorph.capabilities.MorphCapabilityAttacher;
import de.budschie.bmorph.capabilities.blacklist.BlacklistData;
import de.budschie.bmorph.capabilities.blacklist.ConfigManager;
import de.budschie.bmorph.capabilities.bossbar.BossbarCapabilityInstance;
import de.budschie.bmorph.capabilities.bossbar.IBossbarCapability;
import de.budschie.bmorph.capabilities.client.render_data.IRenderDataCapability;
import de.budschie.bmorph.capabilities.client.render_data.RenderDataCapabilityProvider;
import de.budschie.bmorph.capabilities.guardian.GuardianBeamCapabilityHandler;
import de.budschie.bmorph.capabilities.guardian.GuardianBeamCapabilityInstance;
import de.budschie.bmorph.capabilities.guardian.IGuardianBeamCapability;
import de.budschie.bmorph.capabilities.parrot_dance.IParrotDanceCapability;
import de.budschie.bmorph.capabilities.parrot_dance.ParrotDanceCapabilityHandler;
import de.budschie.bmorph.capabilities.phantom_glide.GlideCapabilityHandler;
import de.budschie.bmorph.capabilities.phantom_glide.IGlideCapability;
import de.budschie.bmorph.capabilities.pufferfish.IPufferfishCapability;
import de.budschie.bmorph.capabilities.pufferfish.PufferfishCapabilityHandler;
import de.budschie.bmorph.capabilities.sheep.ISheepCapability;
import de.budschie.bmorph.capabilities.sheep.SheepCapabilityHandler;
import de.budschie.bmorph.capabilities.stand_on_fluid.IStandOnFluidCapability;
import de.budschie.bmorph.capabilities.stand_on_fluid.StandOnFluidInstance;
import de.budschie.bmorph.entity.MorphEntity;
import de.budschie.bmorph.events.AcquiredMorphEvent;
import de.budschie.bmorph.events.EntityClassByTypeCache;
import de.budschie.bmorph.events.MorphCreatedFromEntityEvent;
import de.budschie.bmorph.events.PlayerMorphEvent;
import de.budschie.bmorph.json_integration.AbilityConfigurationHandler;
import de.budschie.bmorph.json_integration.DataTransformerHandler;
import de.budschie.bmorph.json_integration.MorphAbilityManager;
import de.budschie.bmorph.json_integration.MorphNBTHandler;
import de.budschie.bmorph.json_integration.VisualMorphDataHandler;
import de.budschie.bmorph.json_integration.ability_groups.AbilityGroups;
import de.budschie.bmorph.main.BMorphMod;
import de.budschie.bmorph.main.ServerSetup;
import de.budschie.bmorph.morph.MorphItem;
import de.budschie.bmorph.morph.MorphManagerHandlers;
import de.budschie.bmorph.morph.MorphUtil;
import de.budschie.bmorph.morph.functionality.Ability;
import de.budschie.bmorph.morph.functionality.data_transformers.DataTransformer;
import de.budschie.bmorph.util.BudschieUtils;
import java.util.Arrays;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityLeaveWorldEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
public class Events {
    private static final Logger LOGGER = LogManager.getLogger();
    public static int AGGRO_TICKS_TO_PASS = 200;
    public static final MorphAbilityManager MORPH_ABILITY_MANAGER = new MorphAbilityManager();
    public static final MorphNBTHandler MORPH_NBT_HANDLER = new MorphNBTHandler();
    public static final AbilityConfigurationHandler ABILITY_CONFIG_HANDLER = new AbilityConfigurationHandler();
    public static final DataTransformerHandler DATA_TRANSFORMER_HANDLER = new DataTransformerHandler();
    public static final VisualMorphDataHandler VISUAL_MORPH_DATA_HANDLER = new VisualMorphDataHandler();
    public static final AbilityGroups ABILITY_GROUP_HANDLER = new AbilityGroups();

    @SubscribeEvent
    public static void onAcquiredMorph(AcquiredMorphEvent.Post event) {
        BMorphMod.ACQUIRED_MORPH.trigger(event.getMorph(), (ServerPlayer)event.getPlayer());
    }

    @SubscribeEvent
    public static void onRegisterCapabilities(RegisterCapabilitiesEvent event) {
        event.register(IMorphCapability.class);
        event.register(IPufferfishCapability.class);
        event.register(IGuardianBeamCapability.class);
        event.register(IParrotDanceCapability.class);
        event.register(IGlideCapability.class);
        event.register(ISheepCapability.class);
        event.register(IRenderDataCapability.class);
        event.register(IBossbarCapability.class);
        event.register(IStandOnFluidCapability.class);
    }

    @SubscribeEvent
    public static void onEntityCreated(EntityJoinWorldEvent event) {
        if (event.getWorld().m_5776_()) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof IronGolem) {
            IronGolem ironGolem = (IronGolem)entity;
            ironGolem.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)ironGolem, Player.class, 5, false, false, player -> {
                Optional<MorphItem> morphItem;
                IMorphCapability cap = MorphUtil.getCapOrNull((Player)player);
                if (cap != null && (morphItem = cap.getCurrentMorph()).isPresent()) {
                    MorphItem morphItemResolved = morphItem.get();
                    if (morphItemResolved.getEntityType() == EntityType.f_20532_ || morphItemResolved.getEntityType() == EntityType.f_20558_) {
                        return false;
                    }
                    Class<?> entityClass = EntityClassByTypeCache.getClassForEntityType(morphItemResolved.getEntityType());
                    return Enemy.class.isAssignableFrom(entityClass);
                }
                return false;
            }));
        }
    }

    @SubscribeEvent
    public static void onPlayerJoined(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.getEntity().f_19853_.m_5776_()) {
            Player player = event.getPlayer();
            LazyOptional cap = player.getCapability(MorphCapabilityAttacher.MORPH_CAP);
            if (cap.isPresent()) {
                MinecraftForge.EVENT_BUS.post((Event)new PlayerMorphEvent.Server.Pre(player, (IMorphCapability)cap.resolve().get(), ((IMorphCapability)cap.resolve().get()).getCurrentMorph().orElse(null)));
                ((IMorphCapability)cap.resolve().get()).getCurrentMorph().ifPresent(morph -> ((IMorphCapability)cap.resolve().get()).setCurrentAbilities(morph.getAbilities()));
                ((IMorphCapability)cap.resolve().get()).syncWithClients();
                ((IMorphCapability)cap.resolve().get()).applyHealthOnPlayer();
                ((IMorphCapability)cap.resolve().get()).applyAbilities(null, Arrays.asList(new Ability[0]));
                MinecraftForge.EVENT_BUS.post((Event)new PlayerMorphEvent.Server.Post(player, (IMorphCapability)cap.resolve().get(), ((IMorphCapability)cap.resolve().get()).getCurrentMorph().orElse(null)));
            }
            PufferfishCapabilityHandler.INSTANCE.synchronizeWithClients(player);
            GuardianBeamCapabilityHandler.INSTANCE.synchronizeWithClients(player);
            GlideCapabilityHandler.INSTANCE.synchronizeWithClients(player);
            ParrotDanceCapabilityHandler.INSTANCE.synchronizeWithClients(player);
            SheepCapabilityHandler.INSTANCE.synchronizeWithClients(player);
            Events.showBossbarToEveryoneTrackingPlayer(player);
        }
    }

    public static void showBossbarToEveryoneTrackingPlayer(Player player) {
        player.getCapability(BossbarCapabilityInstance.BOSSBAR_CAP).ifPresent(bossbarCap -> bossbarCap.getBossbar().ifPresent(bossbar -> BudschieUtils.getPlayersTrackingEntityAndSelf((ServerPlayer)player).forEach(trackingPlayer -> bossbar.m_6543_(trackingPlayer))));
    }

    @SubscribeEvent
    public static void onPlayerLeft(PlayerEvent.PlayerLoggedOutEvent event) {
        if (!event.getPlayer().f_19853_.m_5776_()) {
            event.getPlayer().getCapability(BossbarCapabilityInstance.BOSSBAR_CAP).ifPresent(bossbarCap -> bossbarCap.clearBossbar());
        }
    }

    @SubscribeEvent
    public static void onEntityLeftWorld(EntityLeaveWorldEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.m_146910_() && player.m_146911_() == Entity.RemovalReason.UNLOADED_WITH_PLAYER) {
                MorphUtil.processCap(player, cap -> cap.removePlayerReferences());
            }
            if (event.getEntity().m_146911_() != Entity.RemovalReason.CHANGED_DIMENSION && event.getEntity().f_19853_.m_5776_()) {
                player.getCapability(RenderDataCapabilityProvider.RENDER_CAP).ifPresent(cap -> cap.invalidateCache());
            }
        }
    }

    @SubscribeEvent
    public static void onDatapackSyncing(OnDatapackSyncEvent event) {
        if (event.getPlayer() == null) {
            BMorphMod.DYNAMIC_ABILITY_REGISTRY.syncWithClients();
            BMorphMod.DYNAMIC_DATA_TRANSFORMER_REGISTRY.syncWithClients();
            BMorphMod.VISUAL_MORPH_DATA.syncWithClients();
            BMorphMod.ABILITY_GROUPS.syncWithClients();
            ServerSetup.server.m_6846_().m_11314_().forEach(player -> {
                IMorphCapability cap = MorphUtil.getCapOrNull((Player)player);
                if (cap != null) {
                    MorphUtil.morphToServer(cap.getCurrentMorphItem(), cap.getCurrentMorphIndex(), (Player)player, true);
                }
            });
        } else {
            BMorphMod.DYNAMIC_ABILITY_REGISTRY.syncWithClient(event.getPlayer());
            BMorphMod.DYNAMIC_DATA_TRANSFORMER_REGISTRY.syncWithClient(event.getPlayer());
            BMorphMod.VISUAL_MORPH_DATA.syncWithClient(event.getPlayer());
            BMorphMod.ABILITY_GROUPS.syncWithClient(event.getPlayer());
        }
    }

    @SubscribeEvent
    public static void onMorphCreatedFromEntity(MorphCreatedFromEntityEvent event) {
        if (event.getEntity() instanceof AgeableMob) {
            ((DataTransformer)BMorphMod.DYNAMIC_DATA_TRANSFORMER_REGISTRY.getEntry(new ResourceLocation("bmorph", "age_cutter"))).transformData(event.getTagIn(), event.getTagOut());
        }
    }

    @SubscribeEvent
    public static void onPlayerIsBeingLoaded(PlayerEvent.StartTracking event) {
        if (event.getTarget() instanceof Player) {
            Player player = (Player)event.getTarget();
            MorphUtil.processCap(player, resolved -> resolved.syncWithClient((ServerPlayer)event.getPlayer()));
            PufferfishCapabilityHandler.INSTANCE.synchronizeWithClient(player, (ServerPlayer)event.getPlayer());
            GuardianBeamCapabilityHandler.INSTANCE.synchronizeWithClient(player, (ServerPlayer)event.getPlayer());
            GlideCapabilityHandler.INSTANCE.synchronizeWithClient(player, (ServerPlayer)event.getPlayer());
            ParrotDanceCapabilityHandler.INSTANCE.synchronizeWithClient(player, (ServerPlayer)event.getPlayer());
            SheepCapabilityHandler.INSTANCE.synchronizeWithClient(player, (ServerPlayer)event.getPlayer());
            event.getTarget().getCapability(BossbarCapabilityInstance.BOSSBAR_CAP).ifPresent(bossbarCap -> bossbarCap.getBossbar().ifPresent(bossbar -> bossbar.m_6543_((ServerPlayer)event.getPlayer())));
        }
    }

    @SubscribeEvent
    public static void onRegisterReloadResourceLoaders(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)ABILITY_CONFIG_HANDLER);
        event.addListener((PreparableReloadListener)MORPH_ABILITY_MANAGER);
        event.addListener((PreparableReloadListener)DATA_TRANSFORMER_HANDLER);
        event.addListener((PreparableReloadListener)MORPH_NBT_HANDLER);
        event.addListener((PreparableReloadListener)VISUAL_MORPH_DATA_HANDLER);
        event.addListener((PreparableReloadListener)ABILITY_GROUP_HANDLER);
    }

    @SubscribeEvent
    public static void onPlayerStoppedBeingLoaded(PlayerEvent.StopTracking event) {
        event.getPlayer().getCapability(GuardianBeamCapabilityInstance.GUARDIAN_BEAM_CAP).ifPresent(cap -> {
            if (cap.getAttackedEntity().isPresent() && cap.getAttackedEntity().get().intValue() == event.getTarget().m_142049_()) {
                GuardianBeamCapabilityHandler.INSTANCE.unattackServer(event.getPlayer());
            }
        });
        Entity entity = event.getTarget();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            event.getTarget().getCapability(BossbarCapabilityInstance.BOSSBAR_CAP).ifPresent(bossbarCap -> bossbarCap.getBossbar().ifPresent(bossbar -> bossbar.m_6539_((ServerPlayer)event.getPlayer())));
        }
    }

    private static boolean mayUseTool(Player player) {
        IMorphCapability cap;
        return player.f_19853_.m_46469_().m_46207_(BMorphMod.ALLOW_MORPH_TOOLS) || (cap = MorphUtil.getCapOrNull(player)) == null || !cap.getCurrentMorph().isPresent();
    }

    @SubscribeEvent
    public static void onPlayerBreakingBlockCheck(PlayerEvent.HarvestCheck event) {
        if (!event.getPlayer().m_7500_() && !Events.mayUseTool(event.getPlayer()) && event.getTargetBlock().m_60834_()) {
            event.setCanHarvest(false);
        }
    }

    @SubscribeEvent
    public static void onPlayerBreakingBlockSpeed(PlayerEvent.BreakSpeed event) {
        if (!event.getPlayer().m_7500_() && !Events.mayUseTool(event.getPlayer()) && event.getPlayer().m_21205_().m_41720_() instanceof TieredItem) {
            event.setNewSpeed(event.getOriginalSpeed() / ((TieredItem)event.getPlayer().m_21205_().m_41720_()).m_43314_().m_6624_());
        }
    }

    @SubscribeEvent
    public static void onPlayerInteractItem(PlayerInteractEvent.RightClickItem event) {
        if (!event.getPlayer().m_7500_() && !Events.mayUseTool(event.getPlayer()) && (event.getItemStack().m_41720_() instanceof TieredItem || event.getItemStack().m_41720_() instanceof ProjectileWeaponItem)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onInteractAtBlock(PlayerInteractEvent.RightClickBlock event) {
        if (!(event.getPlayer().m_7500_() || Events.mayUseTool(event.getPlayer()) || event.getItemStack().m_41720_() instanceof BlockItem)) {
            event.setUseItem(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public static void onPlayerKilledLivingEntity(LivingDeathEvent event) {
        if (!event.getEntity().f_19853_.f_46443_ && ServerSetup.server.m_129900_().m_46207_(BMorphMod.DO_MORPH_DROPS) && event.getSource().m_7639_() instanceof Player) {
            MorphItem morphItem;
            LazyOptional playerMorph;
            boolean selfKill;
            Player player = (Player)event.getSource().m_7639_();
            boolean bl = selfKill = event.getSource().m_7639_() == event.getEntity();
            if (!(player instanceof FakePlayer) && !selfKill && (playerMorph = player.getCapability(MorphCapabilityAttacher.MORPH_CAP)).isPresent() && (morphItem = MorphManagerHandlers.createMorphFromDeadEntity(event.getEntity())) != null) {
                boolean shouldMorph;
                IMorphCapability resolved = (IMorphCapability)playerMorph.resolve().get();
                boolean bl2 = shouldMorph = !ConfigManager.INSTANCE.get(BlacklistData.class).isInBlacklist(event.getEntity().m_6095_().getRegistryName());
                if (!resolved.getMorphList().contains(morphItem) && shouldMorph) {
                    MorphEntity morphEntity = new MorphEntity(event.getEntity().f_19853_, morphItem);
                    morphEntity.m_6034_(event.getEntity().m_20185_(), event.getEntity().m_20186_(), event.getEntity().m_20189_());
                    event.getEntity().f_19853_.m_7967_((Entity)morphEntity);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (!event.getEntity().f_19853_.f_46443_) {
            MorphUtil.processCap(event.getPlayer(), resolved -> resolved.syncWithClients());
        }
    }

    @SubscribeEvent
    public static void onClonePlayer(PlayerEvent.Clone event) {
        if (!event.isWasDeath() || ServerSetup.server.m_129900_().m_46207_(BMorphMod.KEEP_MORPH_INVENTORY)) {
            event.getOriginal().reviveCaps();
            Optional oldCap = event.getOriginal().getCapability(MorphCapabilityAttacher.MORPH_CAP).resolve();
            Optional newCap = event.getPlayer().getCapability(MorphCapabilityAttacher.MORPH_CAP).resolve();
            event.getOriginal().invalidateCaps();
            if (oldCap.isPresent() && newCap.isPresent()) {
                IMorphCapability oldResolved = (IMorphCapability)oldCap.get();
                IMorphCapability newResolved = (IMorphCapability)newCap.get();
                newResolved.setMorphList(oldResolved.getMorphList());
                newResolved.setFavouriteList(oldResolved.getFavouriteList());
                MinecraftForge.EVENT_BUS.post((Event)new PlayerMorphEvent.Server.Pre(event.getPlayer(), newResolved, newResolved.getCurrentMorph().orElse(null)));
                oldResolved.getCurrentMorphIndex().ifPresent(morph -> newResolved.setMorph((int)morph));
                oldResolved.getCurrentMorphItem().ifPresent(morph -> newResolved.setMorph((MorphItem)morph));
                newResolved.setCurrentAbilities(oldResolved.getCurrentAbilities());
                MinecraftForge.EVENT_BUS.post((Event)new PlayerMorphEvent.Server.Post(event.getPlayer(), newResolved, newResolved.getCurrentMorph().orElse(null)));
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawnedEvent(PlayerEvent.PlayerRespawnEvent event) {
        LazyOptional cap;
        if (!event.getPlayer().f_19853_.f_46443_ && ServerSetup.server.m_129900_().m_46207_(BMorphMod.KEEP_MORPH_INVENTORY) && (cap = event.getPlayer().getCapability(MorphCapabilityAttacher.MORPH_CAP)).isPresent()) {
            IMorphCapability resolved = (IMorphCapability)cap.resolve().get();
            resolved.syncWithClients();
            resolved.applyHealthOnPlayer();
            resolved.applyAbilities(null, Arrays.asList(new Ability[0]));
        }
    }

    @SubscribeEvent
    public static void onPlayerDeathEvent(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntityLiving();
        if (livingEntity instanceof Player) {
            LazyOptional cap;
            Player player = (Player)livingEntity;
            if (!event.getEntityLiving().f_19853_.m_5776_() && (cap = player.getCapability(MorphCapabilityAttacher.MORPH_CAP)).isPresent()) {
                IMorphCapability resolved = (IMorphCapability)cap.resolve().get();
                resolved.deapplyAbilities(null, Arrays.asList(new Ability[0]));
                if (!ServerSetup.server.m_129900_().m_46207_(BMorphMod.KEEP_MORPH_INVENTORY)) {
                    for (MorphItem item : resolved.getMorphList().getMorphArrayList()) {
                        MorphEntity morphEntity = new MorphEntity(player.f_19853_, item);
                        morphEntity.m_6034_(player.m_20185_(), player.m_20186_(), player.m_20189_());
                        player.f_19853_.m_7967_((Entity)morphEntity);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTakingDamage(LivingDamageEvent event) {
        if (event.getEntityLiving() instanceof Player) {
            Player player = (Player)event.getEntityLiving();
            LazyOptional cap = player.getCapability(MorphCapabilityAttacher.MORPH_CAP);
            if (cap.isPresent()) {
                IMorphCapability iMorphCapability = (IMorphCapability)cap.resolve().get();
            }
        } else if (event.getSource().m_7639_() instanceof Player && event.getEntityLiving() instanceof Enemy && !event.getEntity().f_19853_.f_46443_) {
            Player source = (Player)event.getSource().m_7639_();
            LazyOptional cap = source.getCapability(MorphCapabilityAttacher.MORPH_CAP);
            Events.aggro((IMorphCapability)cap.resolve().get(), ServerSetup.server.m_129900_().m_46215_(BMorphMod.MORPH_AGGRO_DURATION));
        }
    }

    @SubscribeEvent
    public static void onChangedPose(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            MorphUtil.processCap(event.player, cap -> {
                if (cap.getCurrentMorph().isPresent() && event.player.m_142469_().f_82292_ - event.player.m_142469_().f_82289_ < 1.0 && event.player.m_20089_() == Pose.SWIMMING && !event.player.m_6069_()) {
                    event.player.m_20124_(Pose.STANDING);
                }
            });
            event.player.getCapability(StandOnFluidInstance.STAND_ON_FLUID_CAP).ifPresent(cap -> {
                FluidState state = event.player.f_19853_.m_6425_(new BlockPos(event.player.m_20182_().m_82520_(0.0, 0.5, 0.0)));
                if (cap.containsFluid(state.m_76152_()) && event.player.m_6129_()) {
                    event.player.m_20256_(event.player.m_20184_().m_82490_(0.5).m_82520_(0.0, 0.15, 0.0));
                }
            });
        }
    }

    @SubscribeEvent
    public static void onMorphedClient(PlayerMorphEvent.Client.Post event) {
        event.getPlayer().m_6210_();
    }

    @SubscribeEvent
    public static void onMorphedServer(PlayerMorphEvent.Server.Post event) {
        event.getPlayer().m_6210_();
        if (event.getAboutToMorphTo() == null) {
            return;
        }
        BMorphMod.MORPHED_INTO.trigger(event.getAboutToMorphTo(), (ServerPlayer)event.getPlayer());
    }

    @SubscribeEvent
    public static void onMorphingServer(PlayerMorphEvent.Server.Pre event) {
        if (event.getAboutToMorphTo() != null && event.getAboutToMorphTo().isDisabled()) {
            event.setCanceled(true);
            return;
        }
        event.getMorphCapability().getCurrentMorph().ifPresent(currentMorph -> BMorphMod.DEMORPHED_FROM.trigger((MorphItem)currentMorph, (ServerPlayer)event.getPlayer()));
    }

    private static void aggro(IMorphCapability capability, int aggroDuration) {
        capability.setLastAggroTimestamp(ServerSetup.server.m_129921_());
        capability.setLastAggroDuration(aggroDuration);
    }

    @SubscribeEvent
    public static void onTargetBeingSet(LivingSetAttackTargetEvent event) {
        if (event.getEntityLiving() instanceof Mob && event.getTarget() instanceof Player && event.getTarget() != event.getEntityLiving().m_142581_() && !(event.getEntity() instanceof IronGolem) && !(event.getEntity() instanceof EnderMan)) {
            Player player = (Player)event.getTarget();
            Mob aggressor = (Mob)event.getEntityLiving();
            LazyOptional cap = player.getCapability(MorphCapabilityAttacher.MORPH_CAP);
            if (cap.isPresent()) {
                IMorphCapability resolved = (IMorphCapability)cap.resolve().get();
                if (resolved.getCurrentMorph().isPresent()) {
                    if (!resolved.shouldMobsAttack() && ServerSetup.server.m_129921_() - resolved.getLastAggroTimestamp() > resolved.getLastAggroDuration()) {
                        aggressor.m_6710_(null);
                    } else {
                        Events.aggro(resolved, ServerSetup.server.m_129900_().m_46215_(BMorphMod.MORPH_AGGRO_DURATION));
                    }
                } else {
                    Events.aggro(resolved, ServerSetup.server.m_129900_().m_46215_(BMorphMod.MORPH_AGGRO_DURATION));
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onCalculatingAABB(EntityEvent.Size event) {
        Player player;
        LazyOptional cap;
        if (event.getEntity() instanceof Player && (cap = (player = (Player)event.getEntity()).getCapability(MorphCapabilityAttacher.MORPH_CAP)).isPresent()) {
            float divisor = ShrinkAPIInteractor.getInteractor().getShrinkingValue(player);
            IMorphCapability resolved = (IMorphCapability)cap.resolve().get();
            resolved.getCurrentMorph().ifPresent(item -> {
                try {
                    Entity createdEntity = item.createEntity(event.getEntity().f_19853_);
                    createdEntity.m_20124_(event.getPose());
                    EntityDimensions newSize = createdEntity.m_6972_(Pose.STANDING);
                    if (ShrinkAPIInteractor.getInteractor().isShrunk(player)) {
                        newSize = newSize.m_20390_(1.6f / divisor, 1.0f / divisor);
                    }
                    if (event.getPose() == Pose.CROUCHING) {
                        newSize = newSize.m_20390_(1.0f, 0.85f);
                    }
                    event.setNewSize(newSize, false);
                    event.setNewEyeHeight(newSize.f_20378_ * 0.85f);
                }
                catch (NullPointerException ex) {
                    LOGGER.catching((Throwable)ex);
                    if (!player.f_19853_.f_46443_) {
                        MorphUtil.morphToServer(Optional.empty(), Optional.empty(), player);
                    }
                    resolved.demorph();
                    player.m_6352_((Component)new TextComponent(ChatFormatting.RED + "Couldn't morph to " + item.getEntityType().getRegistryName().toString() + ". This is a compatability issue. If possible, report this to the mod author on GitHub."), new UUID(0L, 0L));
                }
            });
        }
    }
}

