/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import de.budschie.bmorph.capabilities.IMorphCapability;
import de.budschie.bmorph.capabilities.MorphCapabilityAttacher;
import de.budschie.bmorph.gui.AbstractMorphGui;
import de.budschie.bmorph.main.BMorphMod;
import de.budschie.bmorph.morph.MorphItem;
import de.budschie.bmorph.morph.VisualMorphDataRegistry;
import de.budschie.bmorph.util.Pair;
import de.budschie.bmorph.util.UiUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.BiPredicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderNameplateEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FilteredSimpleMorphGui
extends AbstractMorphGui {
    private static final Logger LOGGER = LogManager.getLogger();
    private ArrayList<MorphWidget> morphWidgets;
    private int scroll = 0;
    private int horizontalScroll = 0;
    BiPredicate<IMorphCapability, Integer> filter;

    public FilteredSimpleMorphGui(ResourceLocation morphGuiTypeIcon, String unlocalizedGuiType, BiPredicate<IMorphCapability, Integer> filter) {
        super(morphGuiTypeIcon, unlocalizedGuiType);
        this.filter = filter;
        this.morphWidgets = new ArrayList();
    }

    @Override
    public void showGui() {
        LazyOptional cap = Minecraft.m_91087_().f_91074_.getCapability(MorphCapabilityAttacher.MORPH_CAP);
        if (cap.isPresent()) {
            int i;
            IMorphCapability resolved = (IMorphCapability)cap.resolve().get();
            ArrayList<Integer> morphList = new ArrayList<Integer>();
            for (int i2 = 0; i2 < resolved.getMorphList().getMorphArrayList().size(); ++i2) {
                if (!this.filter.test(resolved, i2)) continue;
                morphList.add(i2);
            }
            this.morphWidgets.add(new MorphWidget(null, false, -1, 69.0f));
            HashMap currentWidgetHeads = new HashMap();
            for (i = 0; i < morphList.size(); ++i) {
                int indexOfMorph = (Integer)morphList.get(i);
                MorphItem item = resolved.getMorphList().getMorphArrayList().get(indexOfMorph);
                float morphScale = 1.0f;
                VisualMorphDataRegistry.VisualMorphData visualData = BMorphMod.VISUAL_MORPH_DATA.getDataForMorph(item);
                if (visualData != null) {
                    morphScale = visualData.getScale();
                }
                MorphWidget widget = new MorphWidget(item, resolved.getFavouriteList().containsMorphItem(item), indexOfMorph, morphScale);
                Pair currentWidgetHead = (Pair)currentWidgetHeads.get(widget.morphItem.getEntityType());
                if (currentWidgetHead != null) {
                    MorphWidget head = (MorphWidget)currentWidgetHead.getA();
                    head.child = widget;
                } else {
                    this.morphWidgets.add(widget);
                }
                currentWidgetHeads.put(widget.morphItem.getEntityType(), new Pair<MorphWidget, Integer>(widget, currentWidgetHead == null ? 0 : (Integer)currentWidgetHead.getB() + 1));
            }
            for (i = 1; i < this.morphWidgets.size(); ++i) {
                MorphWidget widget = this.morphWidgets.get(i);
                Pair currentWidgetHead = (Pair)currentWidgetHeads.get(widget.morphItem.getEntityType());
                widget.depth = (Integer)currentWidgetHead.getB();
            }
        }
        this.checkScroll();
    }

    @Override
    public void hideGui() {
        this.morphWidgets = new ArrayList();
    }

    private void updateGui() {
        LazyOptional cap = Minecraft.m_91087_().f_91074_.getCapability(MorphCapabilityAttacher.MORPH_CAP);
        if (cap.isPresent()) {
            IMorphCapability resolved = (IMorphCapability)cap.resolve().get();
            for (int i = 1; i < this.morphWidgets.size(); ++i) {
                MorphWidget parent = this.morphWidgets.get(i);
                for (MorphWidget child : parent) {
                    child.isFavourite = resolved.getFavouriteList().containsMorphItem(child.morphItem);
                }
            }
        }
    }

    @Override
    public void onFavouriteChanged() {
        this.updateGui();
    }

    @Override
    public void renderWidgets(PoseStack matrixStack, float partialTicks) {
        int startY = Minecraft.m_91087_().m_91268_().m_85446_() / 2 - MorphWidget.getHeight() / 2 - this.scroll * MorphWidget.getHeight();
        int advanceY = 0;
        int scrollOffX = (int)(Math.ceil(Math.max(0.0, (double)this.horizontalScroll - (double)((float)Minecraft.m_91087_().m_91268_().m_85445_() / (float)MorphWidget.getWidth()) * 0.5)) * (double)MorphWidget.getWidth());
        for (int i = 0; i < this.morphWidgets.size(); ++i) {
            if (startY + advanceY + MorphWidget.getHeight() > 0 && startY + advanceY < Minecraft.m_91087_().m_91268_().m_85446_()) {
                MorphWidget widget = this.morphWidgets.get(i);
                matrixStack.m_85836_();
                matrixStack.m_85837_((double)(6 - scrollOffX), (double)(startY + advanceY), 0.0);
                widget.render(matrixStack, i == this.scroll, this.horizontalScroll, partialTicks);
                matrixStack.m_85849_();
            }
            advanceY += MorphWidget.getHeight();
        }
    }

    @Override
    public int getMorphIndex() {
        return this.morphWidgets.get((int)this.scroll).traverse((int)this.horizontalScroll).morphListIndex;
    }

    @Override
    public void scroll(int amount) {
        this.scroll += amount;
        this.checkScroll();
    }

    @Override
    public void horizontalScroll(int scroll) {
        int depth = this.morphWidgets.get((int)this.scroll).depth + 1;
        int n = this.horizontalScroll = depth == 0 ? 0 : (this.horizontalScroll + scroll) % depth;
        if (this.horizontalScroll < 0) {
            this.horizontalScroll = depth + this.horizontalScroll;
        }
    }

    private void checkScroll() {
        this.scroll = Math.max(Math.min(this.scroll, this.morphWidgets.size() - 1), 0);
        this.horizontalScroll(0);
    }

    @Override
    public void setScroll(int scroll) {
        this.scroll = scroll < 0 ? -1 : scroll + 1;
        this.checkScroll();
    }

    @Override
    public MorphItem getMorphItem() {
        return this.scroll < 0 ? null : this.morphWidgets.get((int)this.scroll).traverse((int)this.horizontalScroll).morphItem;
    }

    public ArrayList<MorphWidget> getMorphWidgets() {
        return this.morphWidgets;
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT})
    public static class MorphWidget
    implements Iterable<MorphWidget> {
        public static final int WIDGET_WIDTH = 48;
        public static final int WIDGET_HEIGHT = 64;
        public static final double SCALE_FACTOR = 1.3;
        public static final float ENTITY_SCALE_FACTOR = 30.0f;
        public static final Quaternion ENTITY_ROTATION = new Quaternion(10.0f, 45.0f, 0.0f, true);
        public static final Quaternion NAMEPLATE_ORIENTATION = new Quaternion(0.0f, 135.0f, 0.0f, true);
        private static final ResourceLocation MORPH_WINDOW_NORMAL = new ResourceLocation("bmorph", "textures/gui/morph_window_normal.png");
        private static final ResourceLocation MORPH_WINDOW_SELECTED = new ResourceLocation("bmorph", "textures/gui/morph_window_selected.png");
        private static final ResourceLocation DEMORPH = new ResourceLocation("bmorph", "textures/gui/demorph.png");
        private static final ResourceLocation FAVOURITE = new ResourceLocation("bmorph", "textures/gui/favourite_star.png");
        private static Entity dumbFix = null;
        Optional<Entity> morphEntity = Optional.empty();
        MorphItem morphItem;
        MorphWidget child;
        boolean isFavourite;
        float morphScale;
        int depth;
        boolean crashed = false;
        int morphListIndex;

        public MorphWidget(MorphItem morphItem, boolean isFavourite, int morphListIndex, float morphScale) {
            this.morphItem = morphItem;
            this.isFavourite = isFavourite;
            this.morphListIndex = morphListIndex;
            this.morphScale = morphScale;
        }

        @SubscribeEvent
        public static void onRenderingNameplate(RenderNameplateEvent event) {
            if (dumbFix != null && event.getEntity() == dumbFix && event.getEntity().m_8077_()) {
                event.getPoseStack().m_85845_(NAMEPLATE_ORIENTATION);
                event.setResult(Event.Result.ALLOW);
            }
        }

        public void render(PoseStack stack, boolean isSelected, int horizontalScroll, float partialTicks) {
            this.render(stack, isSelected, horizontalScroll, 0, partialTicks);
        }

        public void render(PoseStack stack, boolean isSelected, int horizontalScroll, int currentDepth, float partialTicks) {
            RenderSystem.m_69478_();
            RenderSystem.m_157456_((int)0, (ResourceLocation)(isSelected && currentDepth == horizontalScroll ? MORPH_WINDOW_SELECTED : MORPH_WINDOW_NORMAL));
            GuiComponent.m_93133_((PoseStack)stack, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)MorphWidget.getWidth(), (int)MorphWidget.getHeight(), (int)MorphWidget.getWidth(), (int)MorphWidget.getHeight());
            if (this.morphItem == null) {
                RenderSystem.m_157456_((int)0, (ResourceLocation)DEMORPH);
                GuiComponent.m_93133_((PoseStack)stack, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)MorphWidget.getWidth(), (int)MorphWidget.getHeight(), (int)MorphWidget.getWidth(), (int)MorphWidget.getHeight());
            } else {
                if (!this.morphEntity.isPresent() && !this.crashed) {
                    try {
                        this.morphEntity = Optional.of(this.morphItem.createEntity((Level)Minecraft.m_91087_().f_91073_));
                    }
                    catch (NullPointerException ex) {
                        this.crashed = true;
                        LOGGER.catching((Throwable)ex);
                        LOGGER.warn("Could not render entity ", (Object)(this.morphItem.getEntityType().getRegistryName().toString() + "."));
                    }
                }
                if (this.morphEntity.isPresent()) {
                    MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
                    stack.m_85836_();
                    stack.m_85837_(30.0, 70.0, 50.0);
                    stack.m_85841_(30.0f * this.morphScale, -30.0f * this.morphScale, 30.0f * this.morphScale);
                    stack.m_85845_(ENTITY_ROTATION);
                    dumbFix = this.morphEntity.get();
                    Minecraft.m_91087_().m_91290_().m_114412_(new Quaternion(0.0f, 0.0f, 0.0f, false));
                    BlockPos position = Minecraft.m_91087_().m_91290_().f_114358_.m_90588_();
                    this.morphEntity.get().m_6034_((double)position.m_123341_(), (double)position.m_123342_(), (double)position.m_123343_());
                    Minecraft.m_91087_().m_91290_().m_114384_(this.morphEntity.get(), 0.0, 0.0, 0.0, 0.0f, 0.0f, stack, (MultiBufferSource)buffer, 0xF000F0);
                    dumbFix = null;
                    buffer.m_109911_();
                    stack.m_85849_();
                }
                if (this.morphItem.isDisabled()) {
                    float calculatedHeight = (float)MorphWidget.getHeight() * this.morphItem.getDisabledProgress(partialTicks);
                    UiUtils.drawColoredRectangle(stack.m_85850_().m_85861_(), 0.0f, MorphWidget.getHeight(), MorphWidget.getWidth(), -calculatedHeight + (float)MorphWidget.getHeight(), 0.0f, 0.0f, 0.0f, 0.8f);
                }
            }
            if (this.isFavourite) {
                RenderSystem.m_157456_((int)0, (ResourceLocation)FAVOURITE);
                GuiComponent.m_93133_((PoseStack)stack, (int)7, (int)7, (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
            }
            if (this.child != null) {
                stack.m_85836_();
                stack.m_85837_((double)MorphWidget.getWidth(), 0.0, 0.0);
                this.child.render(stack, isSelected, horizontalScroll, currentDepth + 1, partialTicks);
                stack.m_85849_();
            }
        }

        public MorphWidget traverse(int amount) {
            MorphWidget currentWidget = this;
            for (int i = 0; i < amount; ++i) {
                currentWidget = currentWidget.child;
            }
            return currentWidget;
        }

        public int getDepth() {
            return this.depth;
        }

        public static int getHeight() {
            return 83;
        }

        public static int getWidth() {
            return 62;
        }

        @Override
        public Iterator<MorphWidget> iterator() {
            return new MorphWidgetIterator(this);
        }
    }

    public static class MorphWidgetIterator
    implements Iterator<MorphWidget> {
        private MorphWidget head;

        public MorphWidgetIterator(MorphWidget head) {
            this.head = head;
        }

        @Override
        public boolean hasNext() {
            return this.head != null;
        }

        @Override
        public MorphWidget next() {
            MorphWidget current = this.head;
            this.head = this.head.child;
            return current;
        }
    }
}

