/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.gui;

import de.budschie.bmorph.capabilities.IMorphCapability;
import de.budschie.bmorph.capabilities.MorphCapabilityAttacher;
import de.budschie.bmorph.gui.AbstractMorphGui;
import de.budschie.bmorph.gui.MorphGuiRegistry;
import de.budschie.bmorph.main.ClientSetup;
import de.budschie.bmorph.morph.FavouriteNetworkingHelper;
import de.budschie.bmorph.network.DeleteOrDropMorph;
import de.budschie.bmorph.network.MainNetworkChannel;
import de.budschie.bmorph.network.MorphRequestAbilityUsage;
import de.budschie.bmorph.network.MorphRequestMorphIndexChange;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class MorphGuiHandler {
    private static int currentIndex = 0;
    private static Optional<AbstractMorphGui> currentMorphGui = Optional.empty();
    private static boolean guiHidden = true;
    private static ArrayList<EyeHeightChangePair> scheduledChanges = new ArrayList();

    public static void traverseToIndexAndSetGui() {
        Iterator iterator = MorphGuiRegistry.REGISTRY.get().getValues().iterator();
        for (int i = 0; i < currentIndex; ++i) {
            iterator.next();
        }
        currentMorphGui = Optional.of((AbstractMorphGui)iterator.next());
    }

    private static void updateCurrentMorphUI() {
        currentMorphGui.ifPresent(ui -> ui.hideGui());
        MorphGuiHandler.traverseToIndexAndSetGui();
        currentMorphGui.get().showGui();
    }

    public static Optional<AbstractMorphGui> getCurrentMorphGui() {
        return currentMorphGui;
    }

    public static void updateMorphUi() {
        if (!guiHidden) {
            MorphGuiHandler.hideGui();
            MorphGuiHandler.showGui();
        }
    }

    public static void showGui() {
        guiHidden = false;
        currentMorphGui.ifPresent(gui -> gui.showGui());
    }

    public static void hideGui() {
        guiHidden = true;
        currentMorphGui.ifPresent(gui -> gui.hideGui());
    }

    public static boolean canGuiBeDisplayed() {
        return !guiHidden && currentMorphGui.isPresent();
    }

    @SubscribeEvent
    public static void onPressedKey(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && Minecraft.m_91087_().f_91073_ != null) {
            if (!currentMorphGui.isPresent()) {
                MorphGuiHandler.traverseToIndexAndSetGui();
            }
            if (ClientSetup.TOGGLE_MORPH_UI.m_90859_()) {
                if (guiHidden) {
                    MorphGuiHandler.showGui();
                } else {
                    MorphGuiHandler.hideGui();
                }
            }
            if (MorphGuiHandler.canGuiBeDisplayed()) {
                if (ClientSetup.SCROLL_DOWN_MORPH_UI.m_90859_()) {
                    currentMorphGui.get().scroll(1);
                }
                if (ClientSetup.SCROLL_UP_MORPH_UI.m_90859_()) {
                    currentMorphGui.get().scroll(-1);
                }
                if (ClientSetup.SCROLL_LEFT_MORPH_UI.m_90859_()) {
                    currentMorphGui.get().horizontalScroll(-1);
                }
                if (ClientSetup.SCROLL_RIGHT_MORPH_UI.m_90859_()) {
                    currentMorphGui.get().horizontalScroll(1);
                }
                if (ClientSetup.NEXT_MORPH_UI.m_90859_()) {
                    ++currentIndex;
                    currentIndex %= MorphGuiRegistry.REGISTRY.get().getValues().size();
                    MorphGuiHandler.traverseToIndexAndSetGui();
                    MorphGuiHandler.updateCurrentMorphUI();
                }
                if (ClientSetup.PREVIOUS_MORPH_UI.m_90859_()) {
                    --currentIndex;
                    currentIndex %= MorphGuiRegistry.REGISTRY.get().getValues().size();
                    MorphGuiHandler.traverseToIndexAndSetGui();
                    MorphGuiHandler.updateCurrentMorphUI();
                }
                if (ClientSetup.TOGGLE_MORPH_FAVOURITE.m_90859_()) {
                    LazyOptional cap = Minecraft.m_91087_().f_91074_.getCapability(MorphCapabilityAttacher.MORPH_CAP);
                    if (cap.isPresent()) {
                        IMorphCapability resolved = (IMorphCapability)cap.resolve().get();
                        int favouriteMorphIndex = currentMorphGui.get().getMorphIndex();
                        if (favouriteMorphIndex < 0) {
                            System.out.println("Yo wat");
                        } else if (resolved.getFavouriteList().containsMorphItem(resolved.getMorphList().getMorphArrayList().get(favouriteMorphIndex))) {
                            FavouriteNetworkingHelper.removeFavouriteMorph(favouriteMorphIndex);
                        } else {
                            FavouriteNetworkingHelper.addFavouriteMorph(favouriteMorphIndex);
                        }
                    }
                    currentMorphGui.ifPresent(morphGui -> morphGui.onFavouriteChanged());
                }
            }
            if (ClientSetup.USE_ABILITY_KEY.m_90859_()) {
                MainNetworkChannel.INSTANCE.sendToServer((Object)new MorphRequestAbilityUsage.MorphRequestAbilityUsagePacket());
            }
        }
    }

    @SubscribeEvent
    public static void onPressedKeyboardKeyRaw(InputEvent.KeyInputEvent event) {
        if (MorphGuiHandler.canGuiBeDisplayed() && currentMorphGui.isPresent()) {
            boolean glfwPress = event.getAction() == 1;
            int morphIndex = currentMorphGui.get().getMorphIndex();
            if (ClientSetup.MORPH_UI.m_90859_() && glfwPress) {
                MainNetworkChannel.INSTANCE.sendToServer((Object)new MorphRequestMorphIndexChange.RequestMorphIndexChangePacket(currentMorphGui.get().getMorphIndex()));
                if (guiHidden) {
                    MorphGuiHandler.showGui();
                } else {
                    MorphGuiHandler.hideGui();
                }
            } else if (morphIndex >= 0) {
                if (ClientSetup.DROP_CURRENT_MORPH.m_90859_() && glfwPress) {
                    MorphGuiHandler.dropOrDelete(true, morphIndex);
                } else if (ClientSetup.DELETE_CURRENT_MORPH.m_90859_() && glfwPress) {
                    MorphGuiHandler.dropOrDelete(false, morphIndex);
                }
            }
        }
    }

    private static void dropOrDelete(boolean drop, int currentMorphIndex) {
        MainNetworkChannel.INSTANCE.sendToServer((Object)new DeleteOrDropMorph.DeleteOrDropMorphPacket(currentMorphIndex, drop));
    }

    @SubscribeEvent
    public static void onRenderOverlayEvent(RenderGameOverlayEvent.Post event) {
        if (MorphGuiHandler.canGuiBeDisplayed() && event.getType() == RenderGameOverlayEvent.ElementType.TEXT && currentMorphGui.isPresent()) {
            currentMorphGui.get().render(event.getMatrixStack(), event.getPartialTicks());
        }
    }

    public static void scheduleEyeHeightChange(float newEyeHeight, Player player) {
        EyeHeightChangePair pair = new EyeHeightChangePair();
        pair.newEyeHeight = newEyeHeight;
        pair.player = player;
        scheduledChanges.add(pair);
    }

    private static class EyeHeightChangePair {
        float newEyeHeight;
        Player player;

        private EyeHeightChangePair() {
        }
    }
}

