/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.json_integration;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.budschie.bmorph.main.BMorphMod;
import de.budschie.bmorph.morph.functionality.Ability;
import de.budschie.bmorph.morph.functionality.AbilityRegistry;
import de.budschie.bmorph.morph.functionality.configurable.ConfigurableAbility;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AbilityConfigurationHandler
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().create();
    private static final Logger LOGGER = LogManager.getLogger();

    public AbilityConfigurationHandler() {
        super(GSON, "configured_abilities");
    }

    protected void apply(Map<ResourceLocation, JsonElement> objectIn, ResourceManager resourceManagerIn, ProfilerFiller profilerIn) {
        BMorphMod.DYNAMIC_ABILITY_REGISTRY.unregisterAll();
        objectIn.forEach((resourceLocation, jsonElement) -> {
            ResourceLocation baseAbility = new ResourceLocation(jsonElement.getAsJsonObject().get("ability").getAsString());
            ConfigurableAbility configurableAbility = (ConfigurableAbility)AbilityRegistry.REGISTRY.get().getValue(baseAbility);
            if (configurableAbility == null) {
                LOGGER.warn(String.format("Configurable ability \"%s\" doesn't exist. Can't parse the configured ability %s.", baseAbility, resourceLocation));
            } else {
                Optional<Ability> ability;
                JsonElement configElement = jsonElement.getAsJsonObject().get("config");
                if (configElement == null) {
                    configElement = new JsonObject();
                }
                if ((ability = configurableAbility.deserialize((JsonElement)configElement.getAsJsonObject())).isPresent()) {
                    ability.get().setResourceLocation((ResourceLocation)resourceLocation);
                    BMorphMod.DYNAMIC_ABILITY_REGISTRY.registerEntry(ability.get());
                }
            }
        });
    }
}

