/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.json_integration;

import de.budschie.bmorph.json_integration.NBTPath;
import de.budschie.bmorph.morph.fallback.FallbackMorphItem;
import de.budschie.bmorph.morph.fallback.IMorphNBTHandler;
import de.budschie.bmorph.morph.functionality.data_transformers.DataTransformer;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.util.LazyOptional;

public class JsonMorphNBTHandler
implements IMorphNBTHandler {
    private NBTPath[] trackedNbt;
    private List<LazyOptional<DataTransformer>> dataTransformers;
    private CompoundTag defaultNbt;

    public JsonMorphNBTHandler(CompoundTag defaultNbt, NBTPath[] trackedNbt, List<LazyOptional<DataTransformer>> dataTransformers) {
        this.defaultNbt = defaultNbt;
        this.trackedNbt = trackedNbt;
        this.dataTransformers = dataTransformers;
    }

    @Override
    public boolean areEquals(FallbackMorphItem item1, FallbackMorphItem item2) {
        CompoundTag fallback1Serialized = item1.serializeAdditional();
        CompoundTag fallback2Serialized = item2.serializeAdditional();
        return fallback1Serialized.equals((Object)fallback2Serialized);
    }

    @Override
    public int getHashCodeFor(FallbackMorphItem item) {
        int hashCode = item.getEntityType().getRegistryName().toString().hashCode();
        CompoundTag nbt = item.serializeAdditional();
        return nbt.hashCode() ^ hashCode;
    }

    @Override
    public CompoundTag applyDefaultNBTData(CompoundTag in) {
        CompoundTag out = this.defaultNbt.m_6426_();
        for (NBTPath nbtPath : this.trackedNbt) {
            nbtPath.copyTo(in, out);
        }
        for (LazyOptional lazyOptional : this.dataTransformers) {
            ((DataTransformer)lazyOptional.resolve().get()).transformData(in, out);
        }
        return out;
    }

    public CompoundTag getDefaultNbt() {
        return this.defaultNbt;
    }

    public NBTPath[] getTrackedNbt() {
        return this.trackedNbt;
    }
}

