/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.json_integration;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.budschie.bmorph.json_integration.ability_groups.AbilityGroupRegistry;
import de.budschie.bmorph.main.BMorphMod;
import de.budschie.bmorph.morph.MorphItem;
import de.budschie.bmorph.morph.functionality.Ability;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MorphAbilityManager
extends SimpleJsonResourceReloadListener {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().create();
    private HashMap<EntityType<?>, List<Ability>> entityAbilityLookup = new HashMap();
    private HashMap<ResourceLocation, List<Ability>> customAbilityLookup = new HashMap();
    private Runnable lazyResolveEntity;
    private Runnable lazyResolveCustom;

    public MorphAbilityManager() {
        super(GSON, "morph_abilities");
    }

    @Nullable
    public List<Ability> getAbilitiesForEntity(EntityType<?> entity) {
        if (this.lazyResolveEntity != null) {
            this.lazyResolveEntity.run();
            this.lazyResolveEntity = null;
        }
        return this.entityAbilityLookup.get(entity);
    }

    @Nullable
    @Deprecated(forRemoval=true)
    public List<Ability> getAbilitiesForItem(MorphItem morphItem) {
        return morphItem.getAbilities();
    }

    @Nullable
    public List<Ability> getAbilitiesForCustomAbilityList(ResourceLocation customAbilityListName) {
        if (this.lazyResolveCustom != null) {
            this.lazyResolveCustom.run();
            this.lazyResolveCustom = null;
        }
        return this.customAbilityLookup.get(customAbilityListName);
    }

    protected void apply(Map<ResourceLocation, JsonElement> objectIn, ResourceManager resourceManagerIn, ProfilerFiller profilerIn) {
        this.entityAbilityLookup.clear();
        HashMap abilityEntries = new HashMap();
        objectIn.forEach((resourceLocation, json) -> {
            try {
                int i;
                JsonObject root = json.getAsJsonObject();
                MorphAbilityKey key = null;
                if (root.has("entity_type")) {
                    key = new MorphAbilityKey(new ResourceLocation(root.get("entity_type").getAsString()), MorphAbilityEntryType.ENTITY);
                } else if (root.has("ability_list_name")) {
                    key = new MorphAbilityKey(new ResourceLocation(root.get("ability_list_name").getAsString()), MorphAbilityEntryType.CUSTOM);
                } else {
                    LOGGER.warn("There was neither an \"entity_type\" nor an \"ability_list_name\" present in " + resourceLocation.toString() + ".");
                }
                JsonArray grantedAbilities = root.getAsJsonArray("grant");
                JsonArray revokedAbilities = root.getAsJsonArray("revoke");
                MorphAbilityEntry entry = abilityEntries.computeIfAbsent(key, keyLambda -> new MorphAbilityEntry());
                for (i = 0; i < grantedAbilities.size(); ++i) {
                    String grantedString = grantedAbilities.get(i).getAsString();
                    if (MorphAbilityManager.isAbilityGroup(grantedString)) {
                        entry.grantAbilityGroup(MorphAbilityManager.stripAbilityGroupIndicator(grantedString));
                        continue;
                    }
                    entry.grantAbility(grantedString);
                }
                for (i = 0; i < revokedAbilities.size(); ++i) {
                    String revokedString = grantedAbilities.get(i).getAsString();
                    if (MorphAbilityManager.isAbilityGroup(revokedString)) {
                        entry.revokeAbilityGroup(MorphAbilityManager.stripAbilityGroupIndicator(revokedString));
                        continue;
                    }
                    entry.revokeAbility(revokedString);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        this.lazyResolveEntity = () -> abilityEntries.forEach((entity, entry) -> {
            try {
                if (entity.type == MorphAbilityEntryType.ENTITY) {
                    if (!ForgeRegistries.ENTITIES.containsKey(entity.name)) {
                        LOGGER.warn(String.format("The given entity %s is not known to the game. Skipping this entry. Please make sure to only load this when the mod for the entity is present. You can do this by putting this JSON file in \"data/<modname>/morph_abilities\".", entity));
                    } else {
                        EntityType entityType = (EntityType)ForgeRegistries.ENTITIES.getValue(entity.name);
                        this.entityAbilityLookup.put(entityType, entry.resolve());
                    }
                } else {
                    this.customAbilityLookup.put(entity.name, entry.resolve());
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        });
    }

    private static boolean isAbilityGroup(String string) {
        return string.startsWith("#");
    }

    private static String stripAbilityGroupIndicator(String inputString) {
        return inputString.substring(1);
    }

    private static class MorphAbilityKey {
        private ResourceLocation name;
        private MorphAbilityEntryType type;

        public MorphAbilityKey(ResourceLocation name, MorphAbilityEntryType type) {
            this.name = name;
            this.type = type;
        }

        public boolean equals(Object obj) {
            if (obj instanceof MorphAbilityKey) {
                MorphAbilityKey key = (MorphAbilityKey)obj;
                return key.name.equals((Object)this.name) && key.type == this.type;
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode() ^ this.type.hashCode();
        }
    }

    private static enum MorphAbilityEntryType {
        ENTITY,
        CUSTOM;

    }

    private static class MorphAbilityEntry {
        private HashSet<String> grantedAbilities = new HashSet();
        private HashSet<String> revokedAbilities = new HashSet();
        private HashSet<String> grantedAbilityGroups = new HashSet();
        private HashSet<String> revokedAbilityGroups = new HashSet();

        private MorphAbilityEntry() {
        }

        public void grantAbility(String abilityResourceLocation) {
            this.grantedAbilities.add(abilityResourceLocation);
        }

        public void revokeAbility(String abilityResourceLocation) {
            this.revokedAbilities.add(abilityResourceLocation);
        }

        public void grantAbilityGroup(String abilityGroupResourceLocation) {
            this.grantedAbilityGroups.add(abilityGroupResourceLocation);
        }

        public void revokeAbilityGroup(String abilityGroupResourceLocation) {
            this.revokedAbilityGroups.add(abilityGroupResourceLocation);
        }

        public List<Ability> resolve() {
            this.resolveAbilityGroup(this.grantedAbilityGroups, this.grantedAbilities);
            this.resolveAbilityGroup(this.revokedAbilityGroups, this.revokedAbilities);
            return this.grantedAbilities.stream().filter(granted -> !this.revokedAbilities.contains(granted)).filter(exists -> {
                if (!BMorphMod.DYNAMIC_ABILITY_REGISTRY.hasEntry(new ResourceLocation(exists))) {
                    LOGGER.warn(String.format("Ability %s does not exist. Please check if every mod is loaded, or if you made a typo. Skipping this ability.", exists));
                    return false;
                }
                return true;
            }).map(strRaw -> (Ability)BMorphMod.DYNAMIC_ABILITY_REGISTRY.getEntry(new ResourceLocation(strRaw))).collect(Collectors.toList());
        }

        private void resolveAbilityGroup(HashSet<String> abilityGroups, HashSet<String> addTo) {
            for (String abilityGroup : abilityGroups) {
                AbilityGroupRegistry.AbilityGroup grantedAbilityGroupResolved = BMorphMod.ABILITY_GROUPS.getEntry(new ResourceLocation(abilityGroup));
                if (grantedAbilityGroupResolved == null) {
                    LOGGER.warn(MessageFormat.format("Ability group {0} in morph_abilities file doesn't exist. Skipping it.", abilityGroup));
                    return;
                }
                for (Ability ability : grantedAbilityGroupResolved.getAbilities()) {
                    addTo.add(ability.getResourceLocation().toString());
                }
            }
        }
    }
}

