/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.json_integration;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.budschie.bmorph.json_integration.JsonMorphNBTHandler;
import de.budschie.bmorph.json_integration.MorphNBTHandlersLoadedEvent;
import de.budschie.bmorph.json_integration.NBTPath;
import de.budschie.bmorph.main.BMorphMod;
import de.budschie.bmorph.morph.MorphManagerHandlers;
import de.budschie.bmorph.morph.functionality.data_transformers.DataTransformer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MorphNBTHandler
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().create();
    private static final Logger LOGGER = LogManager.getLogger();

    public MorphNBTHandler() {
        super(GSON, "morph_nbt");
    }

    protected void apply(Map<ResourceLocation, JsonElement> objectIn, ResourceManager resourceManagerIn, ProfilerFiller profilerIn) {
        HashMap nbtDataHandlers = new HashMap();
        MorphManagerHandlers.FALLBACK.setDataHandlers(nbtDataHandlers);
        objectIn.forEach((resourceLocation, json) -> {
            try {
                JsonElement tracked;
                JsonObject jsonObject = json.getAsJsonObject();
                String entityTypeString = jsonObject.get("entity_type").getAsString();
                EntityType entityType = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(entityTypeString));
                if (entityType == null) {
                    LOGGER.warn("The entity ", (Object)entityTypeString, (Object)" doesn't exist. Please make sure to only load this when the mod for the entity is present. You can do this by putting this JSON file in \"data/<modname>/morph_nbt\".");
                }
                NBTPath[] trackedNbtKeys = new NBTPath[(tracked = jsonObject.get("tracked_nbt_keys")) == null ? 1 : tracked.getAsJsonArray().size() + 1];
                if (tracked != null) {
                    for (int i = 0; i < tracked.getAsJsonArray().size(); ++i) {
                        trackedNbtKeys[i] = NBTPath.valueOf(tracked.getAsJsonArray().get(i).getAsString());
                    }
                }
                JsonElement dataTransformersArrayElement = jsonObject.get("data_transformers");
                ArrayList<LazyOptional<DataTransformer>> dataTransformers = new ArrayList<LazyOptional<DataTransformer>>();
                if (dataTransformersArrayElement != null) {
                    for (JsonElement dataTransformerName : dataTransformersArrayElement.getAsJsonArray()) {
                        ResourceLocation toUse = new ResourceLocation(dataTransformerName.getAsString());
                        dataTransformers.add(LazyOptional.of(() -> (DataTransformer)BMorphMod.DYNAMIC_DATA_TRANSFORMER_REGISTRY.getEntry(toUse)));
                    }
                }
                trackedNbtKeys[trackedNbtKeys.length - 1] = new NBTPath("CustomName");
                JsonElement defaultNBTObject = jsonObject.get("default_nbt");
                CompoundTag defaultNBT = defaultNBTObject == null ? new CompoundTag() : new TagParser(new StringReader(defaultNBTObject.getAsString())).m_129373_();
                JsonMorphNBTHandler nbtHandler = new JsonMorphNBTHandler(defaultNBT, trackedNbtKeys, dataTransformers);
                nbtDataHandlers.put(entityType, nbtHandler);
            }
            catch (CommandSyntaxException e) {
                e.printStackTrace();
            }
        });
        MorphNBTHandlersLoadedEvent event = new MorphNBTHandlersLoadedEvent(nbtDataHandlers);
        MinecraftForge.EVENT_BUS.post((Event)event);
    }
}

