/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.json_integration;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class NBTPath {
    private String[] nodes;
    public static final Codec<NBTPath> CODEC = Codec.STRING.comapFlatMap(fromStr -> DataResult.success((Object)NBTPath.valueOf(fromStr)), toStr -> toStr.toString());

    public static NBTPath valueOf(String path) {
        return new NBTPath(path.split(";"));
    }

    public NBTPath(String ... nodes) {
        this.nodes = nodes;
    }

    public String[] getNodes() {
        return this.nodes;
    }

    public String getLastNode() {
        return this.nodes[this.nodes.length - 1];
    }

    public CompoundTag getOrCreateParent(CompoundTag compound) {
        CompoundTag currentCompound = compound;
        for (int i = 0; i < this.nodes.length - 1; ++i) {
            boolean doesNodeExist = currentCompound.m_128441_(this.nodes[i]);
            CompoundTag newCompound = currentCompound.m_128469_(this.nodes[i]);
            if (!doesNodeExist) {
                currentCompound.m_128365_(this.nodes[i], (Tag)newCompound);
            }
            currentCompound = newCompound;
        }
        return currentCompound;
    }

    public void setTag(CompoundTag root, Tag tag) {
        this.getOrCreateParent(root).m_128365_(this.getLastNode(), tag);
    }

    public Tag resolve(CompoundTag compoundNBT) {
        CompoundTag currentCompound = compoundNBT;
        for (int i = 0; i < this.nodes.length - 1; ++i) {
            currentCompound = currentCompound.m_128469_(this.nodes[i]);
        }
        return currentCompound.m_128423_(this.nodes[this.nodes.length - 1]);
    }

    public Optional<Tag> resolveOptional(CompoundTag compoundNBT) {
        CompoundTag currentCompound = compoundNBT;
        for (int i = 0; i < this.nodes.length - 1; ++i) {
            currentCompound = currentCompound.m_128469_(this.nodes[i]);
        }
        return currentCompound.m_128441_(this.getLastNode()) ? Optional.of(currentCompound.m_128423_(this.getLastNode())) : Optional.empty();
    }

    public void copyTo(CompoundTag from, CompoundTag to) {
        this.copyTo(from, to, this);
    }

    public void copyTo(CompoundTag from, CompoundTag to, NBTPath toPath) {
        Tag fromNBT = this.resolve(from);
        if (fromNBT == null) {
            return;
        }
        toPath.getOrCreateParent(to).m_128365_(toPath.nodes[toPath.nodes.length - 1], fromNBT.m_6426_());
    }

    public String toString() {
        return String.join((CharSequence)";", this.nodes);
    }
}

