/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.json_integration.ability_groups;

import de.budschie.bmorph.morph.functionality.Ability;
import de.budschie.bmorph.network.AbilityGroupSync;
import de.budschie.bmorph.util.DynamicRegistry;
import de.budschie.bmorph.util.IDynamicRegistryObject;
import java.util.Collection;
import java.util.HashSet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class AbilityGroupRegistry
extends DynamicRegistry<AbilityGroup, AbilityGroupSync.AbilityGroupSyncPacket> {
    public Runnable fillRegistry;

    @Override
    public AbilityGroupSync.AbilityGroupSyncPacket getPacket() {
        return AbilityGroupSync.AbilityGroupSyncPacket.serverPacket(this.values());
    }

    @Override
    public AbilityGroup getEntry(ResourceLocation key) {
        this.fillRegistryIfPossible();
        return (AbilityGroup)super.getEntry(key);
    }

    @Override
    public boolean hasEntry(ResourceLocation key) {
        this.fillRegistryIfPossible();
        return super.hasEntry(key);
    }

    @Override
    public Collection<AbilityGroup> values() {
        this.fillRegistryIfPossible();
        return super.values();
    }

    @Override
    public boolean isEmpty() {
        this.fillRegistryIfPossible();
        return super.isEmpty();
    }

    @Override
    public void syncWithClient(ServerPlayer player) {
        this.fillRegistryIfPossible();
        super.syncWithClient(player);
    }

    @Override
    public void syncWithClients() {
        this.fillRegistryIfPossible();
        super.syncWithClients();
    }

    public void setFillRegistry(Runnable fillRegistry) {
        this.fillRegistry = fillRegistry;
    }

    private void fillRegistryIfPossible() {
        if (this.fillRegistry != null) {
            this.unregisterAll();
            this.fillRegistry.run();
            this.fillRegistry = null;
        }
    }

    public static class AbilityGroup
    implements IDynamicRegistryObject {
        private HashSet<Ability> abilities = new HashSet();
        private ResourceLocation resourceLocation;

        public AbilityGroup(ResourceLocation resourceLocation) {
            this.resourceLocation = resourceLocation;
        }

        public void addAbility(Ability ability) {
            this.abilities.add(ability);
        }

        public Collection<Ability> getAbilities() {
            return this.abilities;
        }

        public boolean containsAbility(Ability ability) {
            return this.abilities.contains(ability);
        }

        @Override
        public ResourceLocation getResourceLocation() {
            return this.resourceLocation;
        }

        @Override
        public void setResourceLocation(ResourceLocation name) {
            this.resourceLocation = name;
        }
    }
}

