/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.mixin;

import de.budschie.bmorph.morph.MorphUtil;
import de.budschie.bmorph.morph.functionality.Ability;
import de.budschie.bmorph.morph.functionality.configurable.NoFlames;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public class FireImmunityMixin {
    @Inject(method={"fireImmune()Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void fireImmuneInject(CallbackInfoReturnable<Boolean> callback) {
        Entity entity = (Entity)this;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            MorphUtil.processCap(player, cap -> {
                boolean markedNoFlames = false;
                if (cap.getCurrentAbilities() != null) {
                    for (Ability ability : cap.getCurrentAbilities()) {
                        if (!(ability instanceof NoFlames)) continue;
                        markedNoFlames = true;
                        break;
                    }
                }
                if (markedNoFlames) {
                    callback.setReturnValue((Object)true);
                }
            });
        }
    }
}

