/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.mixin;

import de.budschie.bmorph.capabilities.IMorphCapability;
import de.budschie.bmorph.morph.MorphUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.sensing.VillagerHostilesSensor;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={VillagerHostilesSensor.class})
public class IsHostileMixin {
    @Inject(method={"isHostile(Lnet/minecraft/world/entity/LivingEntity;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void isHostileInjection(LivingEntity toCheck, CallbackInfoReturnable<Boolean> callback) {
        Player player;
        IMorphCapability morphCap;
        if (toCheck instanceof Player && (morphCap = MorphUtil.getCapOrNull(player = (Player)toCheck)) != null) {
            morphCap.getCurrentMorph().ifPresent(item -> callback.setReturnValue((Object)VillagerHostilesSensor.f_26842_.containsKey(item.getEntityType())));
        }
    }

    @Inject(method={"isClose(Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/entity/LivingEntity;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void isCloseInjection(LivingEntity villager, LivingEntity hostileEntity, CallbackInfoReturnable<Boolean> callback) {
        Player player;
        IMorphCapability morphCap;
        if (hostileEntity instanceof Player && (morphCap = MorphUtil.getCapOrNull(player = (Player)hostileEntity)) != null) {
            morphCap.getCurrentMorph().ifPresent(item -> {
                float distance = ((Float)VillagerHostilesSensor.f_26842_.getOrDefault(item.getEntityType(), (Object)Float.valueOf(0.0f))).floatValue();
                callback.setReturnValue((Object)(villager.m_20280_((Entity)hostileEntity) <= (double)(distance * distance) ? 1 : 0));
            });
        }
    }
}

