/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import de.budschie.bmorph.capabilities.IMorphCapability;
import de.budschie.bmorph.capabilities.MorphCapabilityAttacher;
import de.budschie.bmorph.capabilities.client.render_data.IRenderDataCapability;
import de.budschie.bmorph.capabilities.client.render_data.RenderDataCapabilityProvider;
import de.budschie.bmorph.util.ProtectedFieldAccess;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.QuadrupedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlayerRenderer.class})
public abstract class PlayerRendererMixin
extends LivingEntityRenderer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    private static ProtectedFieldAccess<ModelPart, QuadrupedModel> LEFT_FRONT_LEG_ACCESSOR = new ProtectedFieldAccess(QuadrupedModel.class, "f_170855_");
    private static ProtectedFieldAccess<ModelPart, QuadrupedModel> RIGHT_FRONT_LEG_ACCESSOR = new ProtectedFieldAccess(QuadrupedModel.class, "f_170854_");

    public PlayerRendererMixin(EntityRendererProvider.Context rendererManager, PlayerModel<AbstractClientPlayer> entityModelIn, float shadowSizeIn) {
        super(rendererManager, entityModelIn, shadowSizeIn);
    }

    @Inject(at={@At(value="HEAD")}, method={"renderRightHand(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/client/player/AbstractClientPlayer;)V"}, cancellable=true)
    private void renderRightHand(PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, AbstractClientPlayer playerIn, CallbackInfo info) {
        if (this.checkMorphPresent((Player)playerIn)) {
            info.cancel();
            Entity cachedEntity = ((IRenderDataCapability)playerIn.getCapability(RenderDataCapabilityProvider.RENDER_CAP).resolve().get()).getOrCreateCachedEntity((Player)playerIn);
            EntityRenderer renderer = Minecraft.m_91087_().m_91290_().m_114382_(cachedEntity);
            if (renderer instanceof LivingEntityRenderer) {
                ModelPart armRenderer = null;
                LivingEntityRenderer living = (LivingEntityRenderer)renderer;
                if (living.m_7200_() instanceof HumanoidModel) {
                    armRenderer = ((HumanoidModel)living.m_7200_()).f_102811_;
                }
                if (living.m_7200_() instanceof QuadrupedModel) {
                    armRenderer = LEFT_FRONT_LEG_ACCESSOR.getValue((QuadrupedModel)living.m_7200_());
                }
                if (armRenderer != null) {
                    this.renderArm(false, playerIn, armRenderer, matrixStackIn, combinedLightIn, bufferIn, living, (LivingEntity)cachedEntity, combinedLightIn);
                }
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"renderLeftHand(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/client/player/AbstractClientPlayer;)V"}, cancellable=true)
    private void renderLeftHand(PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, AbstractClientPlayer playerIn, CallbackInfo info) {
        if (this.checkMorphPresent((Player)playerIn)) {
            info.cancel();
            Entity cachedEntity = ((IRenderDataCapability)playerIn.getCapability(RenderDataCapabilityProvider.RENDER_CAP).resolve().get()).getOrCreateCachedEntity((Player)playerIn);
            EntityRenderer renderer = Minecraft.m_91087_().m_91290_().m_114382_(cachedEntity);
            if (renderer instanceof LivingEntityRenderer) {
                ModelPart armRenderer = null;
                LivingEntityRenderer living = (LivingEntityRenderer)renderer;
                if (living.m_7200_() instanceof HumanoidModel) {
                    armRenderer = ((HumanoidModel)living.m_7200_()).f_102811_;
                }
                if (living.m_7200_() instanceof QuadrupedModel) {
                    armRenderer = RIGHT_FRONT_LEG_ACCESSOR.getValue((QuadrupedModel)living.m_7200_());
                }
                if (armRenderer != null) {
                    this.renderArm(true, playerIn, armRenderer, matrixStackIn, combinedLightIn, bufferIn, living, (LivingEntity)cachedEntity, combinedLightIn);
                }
            }
        }
    }

    @Shadow
    private void m_117818_(AbstractClientPlayer clientPlayer) {
    }

    private void renderArm(boolean isLeft, AbstractClientPlayer player, ModelPart arm, PoseStack matrixStack, int combinedLightIn, MultiBufferSource buffer, LivingEntityRenderer<? super LivingEntity, ?> renderer, LivingEntity entity, int light) {
        matrixStack.m_85836_();
        if (renderer.m_7200_() instanceof QuadrupedModel) {
            matrixStack.m_85837_(isLeft ? 0.1 : -0.1, -0.6, 0.5);
        }
        this.m_117818_(player);
        renderer.m_7200_().f_102608_ = 0.0f;
        if (renderer instanceof HumanoidMobRenderer) {
            HumanoidMobRenderer casted = (HumanoidMobRenderer)renderer;
            ((HumanoidModel)casted.m_7200_()).f_102818_ = 0.0f;
            ((HumanoidModel)casted.m_7200_()).f_102817_ = false;
        }
        if ((renderer instanceof HumanoidMobRenderer || renderer.m_7200_() instanceof PlayerModel) && isLeft && player.m_5737_() == HumanoidArm.LEFT && player.m_21120_(InteractionHand.MAIN_HAND).m_41619_()) {
            matrixStack.m_85837_(0.65, 0.0, 0.0);
        }
        renderer.m_7200_().m_6973_((Entity)entity, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        arm.f_104203_ = 0.0f;
        arm.m_104301_(matrixStack, buffer.m_6299_(RenderType.m_110452_((ResourceLocation)renderer.m_5478_((Entity)entity))), combinedLightIn, OverlayTexture.f_118083_);
        matrixStack.m_85849_();
    }

    private boolean checkMorphPresent(Player player) {
        return player != null && player.getCapability(MorphCapabilityAttacher.MORPH_CAP).isPresent() && ((IMorphCapability)player.getCapability(MorphCapabilityAttacher.MORPH_CAP).resolve().get()).getCurrentMorph().isPresent();
    }
}

