/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.morph;

import de.budschie.bmorph.morph.MorphItem;
import de.budschie.bmorph.morph.MorphList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;

public class FavouriteList {
    private MorphList morphList;
    private HashSet<FavouriteMorphItem> favourites = new HashSet();

    public FavouriteList(MorphList morphList) {
        this.morphList = morphList;
    }

    public CompoundTag serialize() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128408_("favouriteIndices", this.favourites.stream().map(item -> item.morphListIndex).collect(Collectors.toList()));
        return nbt;
    }

    public void deserialize(CompoundTag nbt) {
        int[] favouriteIndices;
        for (int favourite : favouriteIndices = nbt.m_128465_("favouriteIndices")) {
            this.favourites.add(new FavouriteMorphItem(this.morphList.getMorphArrayList().get(favourite), favourite));
        }
    }

    public void setMorphList(MorphList morphList) {
        this.morphList = morphList;
    }

    public void serializePacket(FriendlyByteBuf buffer) {
        int[] favouriteIndices = new int[this.favourites.size()];
        int i = 0;
        Iterator<FavouriteMorphItem> items = this.favourites.iterator();
        while (items.hasNext()) {
            favouriteIndices[i++] = items.next().morphListIndex;
        }
        buffer.m_130089_(favouriteIndices);
    }

    public void deserializePacket(FriendlyByteBuf buffer) {
        int[] favouriteIndices = buffer.m_130100_();
        this.favourites.clear();
        for (int favouriteIndex : favouriteIndices) {
            this.addFavourite(favouriteIndex);
        }
    }

    public HashSet<FavouriteMorphItem> getFavourites() {
        return this.favourites;
    }

    public void addFavourite(int indexInMorphList) {
        this.favourites.add(new FavouriteMorphItem(this.morphList.getMorphArrayList().get(indexInMorphList), indexInMorphList));
    }

    public void removeFavourite(int indexInMorphList) {
        this.favourites.remove(new FavouriteMorphItem(this.morphList.getMorphArrayList().get(indexInMorphList), indexInMorphList));
    }

    public boolean containsMorphItem(MorphItem morphItem) {
        return this.favourites.contains(new FavouriteMorphItem(morphItem, 696969420));
    }

    public static class FavouriteMorphItem {
        private MorphItem morphItem;
        private int morphListIndex;

        public FavouriteMorphItem(MorphItem morphItem, int morphListIndex) {
            this.morphItem = morphItem;
            this.morphListIndex = morphListIndex;
        }

        public MorphItem getMorphItem() {
            return this.morphItem;
        }

        public int getMorphListIndex() {
            return this.morphListIndex;
        }

        public int hashCode() {
            return this.morphItem.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof FavouriteMorphItem && ((FavouriteMorphItem)obj).morphItem.equals(this.morphItem);
        }
    }
}

