/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.morph;

import com.ibm.icu.text.MessageFormat;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LazyRegistryWrapper<T> {
    private static final Logger LOGGER = LogManager.getLogger();
    private ResourceLocation tagName;
    private Function<ResourceLocation, T> tagSupplier;
    private boolean hasTag = true;
    private boolean hasErrored = false;
    private T cachedTag;

    public LazyRegistryWrapper(ResourceLocation tagName, Function<ResourceLocation, T> tagSupplier) {
        this.tagName = tagName;
        this.tagSupplier = tagSupplier;
    }

    public ResourceLocation getResourceLocation() {
        return this.tagName;
    }

    private void resolveIfNotPresent() {
        if (this.hasTag && this.cachedTag == null) {
            this.cachedTag = this.tagSupplier.apply(this.tagName);
            if (this.cachedTag == null) {
                this.hasTag = false;
                if (!this.hasErrored) {
                    LOGGER.warn(MessageFormat.format((String)"The resource location {0} could not be resolved to a registry type.", (Object[])new Object[]{this.tagName.toString()}));
                    this.hasErrored = true;
                }
            }
        }
    }

    public T getWrappedType() {
        this.resolveIfNotPresent();
        return this.cachedTag;
    }
}

