/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.morph;

import de.budschie.bmorph.events.Events;
import de.budschie.bmorph.morph.functionality.Ability;
import de.budschie.bmorph.util.BudschieUtils;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class MorphItem {
    protected final Logger LOGGER = LogManager.getLogger();
    private String morphItemId;
    private int disabledUntil = -1;
    private int totalDisableTime = 1;
    private Optional<ResourceLocation> customAbilityList = Optional.empty();
    private Optional<EntityType<?>> abilityListFromEntity = Optional.empty();

    protected MorphItem(String morphItemId) {
        this.morphItemId = morphItemId;
    }

    public void setCustomAbilityList(ResourceLocation customAbilityList) {
        this.customAbilityList = Optional.of(customAbilityList);
    }

    public void setAbilityListFromEntity(EntityType<?> abilityListFromEntity) {
        this.abilityListFromEntity = Optional.of(abilityListFromEntity);
    }

    public CompoundTag serialize() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("id", this.getMorphItemId());
        nbt.m_128365_("additional", (Tag)this.serializeAdditional());
        if (this.isDisabled()) {
            nbt.m_128405_("disabled_until", BudschieUtils.convertToRelativeTime(this.disabledUntil));
            nbt.m_128405_("total_stun_time", this.totalDisableTime);
        }
        if (this.customAbilityList.isPresent()) {
            nbt.m_128359_("custom_ability_list", this.customAbilityList.get().toString());
        } else if (this.abilityListFromEntity.isPresent()) {
            nbt.m_128359_("ability_list_from_entity", this.abilityListFromEntity.get().getRegistryName().toString());
        }
        return nbt;
    }

    public void deserialize(CompoundTag nbt) {
        if (!nbt.m_128461_("id").equals(this.getMorphItemId())) {
            throw new IllegalArgumentException("The wrong morph item is being serialized. Please report this bug to the developer.");
        }
        this.deserializeAdditional(nbt.m_128469_("additional"));
        if (nbt.m_128425_("disabled_until", 3)) {
            this.disabledUntil = BudschieUtils.convertToAbsoluteTime(nbt.m_128451_("disabled_until"));
            this.totalDisableTime = nbt.m_128451_("total_stun_time");
        }
        if (nbt.m_128425_("custom_ability_list", 8)) {
            this.setCustomAbilityList(new ResourceLocation(nbt.m_128461_("custom_ability_list")));
        } else if (nbt.m_128425_("ability_list_from_entity", 8)) {
            this.setAbilityListFromEntity((EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(nbt.m_128461_("ability_list_from_entity"))));
        }
    }

    public List<Ability> getAbilities() {
        if (this.customAbilityList.isPresent()) {
            List<Ability> abilities = Events.MORPH_ABILITY_MANAGER.getAbilitiesForCustomAbilityList(this.customAbilityList.get());
            if (abilities == null) {
                this.LOGGER.warn(MessageFormat.format("The custom ability list {0} for the entity type {1} does not exist. Defaulting to an empty list of abilities.", this.customAbilityList.get().toString(), this.getEntityType().getRegistryName().toString()));
                return Arrays.asList(new Ability[0]);
            }
            return abilities;
        }
        EntityType<?> toGetAbilitiesFrom = this.abilityListFromEntity.isPresent() ? this.abilityListFromEntity.get() : this.getEntityType();
        List<Ability> defaultAbilities = Events.MORPH_ABILITY_MANAGER.getAbilitiesForEntity(toGetAbilitiesFrom);
        return defaultAbilities == null ? Arrays.asList(new Ability[0]) : defaultAbilities;
    }

    protected Optional<ResourceLocation> getCustomAbilityList() {
        return this.customAbilityList;
    }

    public void disable(int forTicks) {
        this.totalDisableTime = forTicks;
        this.disabledUntil = BudschieUtils.convertToAbsoluteTime(forTicks);
    }

    public boolean isDisabled() {
        return BudschieUtils.getUniversalTickTime() < this.disabledUntil;
    }

    public float getDisabledProgress(float partialTicks) {
        float timeLeft = BudschieUtils.convertToRelativeTime(this.disabledUntil);
        float totalTime = this.totalDisableTime;
        return (timeLeft - partialTicks) / totalTime;
    }

    public float getDisabledProgress() {
        return this.getDisabledProgress(0.0f);
    }

    public abstract void deserializeAdditional(CompoundTag var1);

    public abstract CompoundTag serializeAdditional();

    public abstract EntityType<?> getEntityType();

    public abstract Entity createEntity(Level var1) throws NullPointerException;

    public boolean isAllowedToPickUp(Player picker) {
        return true;
    }

    public String getMorphItemId() {
        return this.morphItemId;
    }
}

