/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.morph;

import de.budschie.bmorph.morph.MorphHandler;
import de.budschie.bmorph.morph.MorphItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.EntityType;

public class MorphList {
    private HashMap<EntityType<?>, Integer> entityCount = new HashMap();
    private HashSet<MorphItem> playerMorphItems = new HashSet();
    private ArrayList<MorphItem> morphArrayList = new ArrayList();

    public CompoundTag serializeNBT() {
        CompoundTag rootTag = new CompoundTag();
        for (int i = 0; i < this.morphArrayList.size(); ++i) {
            rootTag.m_128365_(Integer.valueOf(i).toString(), (Tag)this.morphArrayList.get(i).serialize());
        }
        return rootTag;
    }

    public void deserializeNBT(CompoundTag tag) {
        Set keys = tag.m_128431_();
        for (int i = 0; i < keys.size(); ++i) {
            CompoundTag morphTag = tag.m_128469_(String.valueOf(i));
            MorphItem item = MorphHandler.deserializeMorphItem(morphTag);
            this.playerMorphItems.add(item);
            this.morphArrayList.add(item);
            this.incrementEntityCount(item.getEntityType());
        }
    }

    public void serializePacket(FriendlyByteBuf packet) {
        packet.writeInt(this.morphArrayList.size());
        for (MorphItem item : this.morphArrayList) {
            packet.m_130079_(item.serialize());
        }
    }

    public void deserializePacket(FriendlyByteBuf packet) {
        int amount = packet.readInt();
        this.morphArrayList = new ArrayList(amount);
        for (int i = 0; i < amount; ++i) {
            this.morphArrayList.add(MorphHandler.deserializeMorphItem(packet.m_130260_()));
        }
    }

    public int addToMorphList(MorphItem item) {
        this.playerMorphItems.add(item);
        this.morphArrayList.add(item);
        this.incrementEntityCount(item.getEntityType());
        return this.morphArrayList.size() - 1;
    }

    public void removeFromMorphList(int index) {
        MorphItem item = this.morphArrayList.remove(index);
        this.playerMorphItems.remove(item);
        this.decrementEntityCount(item.getEntityType());
    }

    public int getEntityCount(EntityType<?> ofType) {
        return this.entityCount.getOrDefault(ofType, 0);
    }

    public boolean contains(MorphItem item) {
        return this.playerMorphItems.contains(item);
    }

    public ArrayList<MorphItem> getMorphArrayList() {
        return this.morphArrayList;
    }

    private void decrementEntityCount(EntityType<?> type) {
        if (this.entityCount.containsKey(type)) {
            int currentValue = this.entityCount.get(type);
            if (currentValue <= 1) {
                this.entityCount.remove(type);
            } else {
                this.entityCount.put(type, currentValue - 1);
            }
        }
    }

    private void incrementEntityCount(EntityType<?> type) {
        if (this.entityCount.containsKey(type)) {
            this.entityCount.put(type, this.entityCount.get(type) + 1);
        } else {
            this.entityCount.put(type, 1);
        }
    }
}

