/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.morph;

import de.budschie.bmorph.capabilities.IMorphCapability;
import de.budschie.bmorph.capabilities.MorphCapabilityAttacher;
import de.budschie.bmorph.capabilities.client.render_data.IRenderDataCapability;
import de.budschie.bmorph.capabilities.client.render_data.RenderDataCapabilityProvider;
import de.budschie.bmorph.events.PlayerMorphEvent;
import de.budschie.bmorph.main.BMorphMod;
import de.budschie.bmorph.morph.MorphItem;
import de.budschie.bmorph.morph.functionality.Ability;
import de.budschie.bmorph.render_handler.EntitySynchronizerRegistry;
import de.budschie.bmorph.render_handler.IEntitySynchronizer;
import de.budschie.bmorph.render_handler.RenderHandler;
import de.budschie.bmorph.render_handler.animations.ScaleAnimation;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.DistExecutor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MorphUtil {
    private static Logger LOGGER = LogManager.getLogger();

    public static void morphToServer(Optional<MorphItem> morphItem, Optional<Integer> morphIndex, Player player) {
        MorphUtil.morphToServer(morphItem, morphIndex, player, false);
    }

    public static void processCap(Player player, Consumer<IMorphCapability> capConsumer) {
        LazyOptional cap = player.getCapability(MorphCapabilityAttacher.MORPH_CAP);
        if (cap.isPresent()) {
            IMorphCapability resolved = (IMorphCapability)cap.resolve().get();
            capConsumer.accept(resolved);
        }
    }

    public static IMorphCapability getCapOrNull(Player playerEntity) {
        if (playerEntity == null) {
            return null;
        }
        LazyOptional cap = playerEntity.getCapability(MorphCapabilityAttacher.MORPH_CAP);
        if (cap.isPresent()) {
            return (IMorphCapability)cap.resolve().get();
        }
        return null;
    }

    public static void morphToServer(Optional<MorphItem> morphItem, Optional<Integer> morphIndex, Player player, boolean force) {
        LazyOptional cap = player.getCapability(MorphCapabilityAttacher.MORPH_CAP);
        if (cap.isPresent()) {
            IMorphCapability resolved = (IMorphCapability)cap.resolve().get();
            MorphItem aboutToMorphTo = null;
            if (morphItem.isPresent()) {
                aboutToMorphTo = morphItem.get();
            } else if (morphIndex.isPresent()) {
                aboutToMorphTo = resolved.getMorphList().getMorphArrayList().get(morphIndex.get());
            }
            boolean isCanceled = MinecraftForge.EVENT_BUS.post((Event)new PlayerMorphEvent.Server.Pre(player, resolved, aboutToMorphTo));
            if (!isCanceled || force) {
                List<Ability> newAbilities = null;
                List<Ability> oldAbilities = resolved.getCurrentAbilities();
                MorphItem oldMorphItem = resolved.getCurrentMorph().orElse(null);
                if (aboutToMorphTo != null) {
                    newAbilities = aboutToMorphTo.getAbilities();
                }
                resolved.deapplyAbilities(aboutToMorphTo, newAbilities == null ? Arrays.asList(new Ability[0]) : newAbilities);
                if (morphIndex.isPresent()) {
                    resolved.setMorph(morphIndex.get());
                } else if (morphItem.isPresent()) {
                    resolved.setMorph(morphItem.get());
                } else {
                    resolved.demorph();
                }
                resolved.setCurrentAbilities(newAbilities);
                resolved.applyAbilities(oldMorphItem, oldAbilities == null ? Arrays.asList(new Ability[0]) : oldAbilities);
                resolved.syncMorphChange();
                resolved.applyHealthOnPlayer();
                MinecraftForge.EVENT_BUS.post((Event)new PlayerMorphEvent.Server.Post(player, resolved, aboutToMorphTo));
            }
        }
    }

    public static void morphToClient(Optional<MorphItem> morphItem, Optional<Integer> morphIndex, ArrayList<String> abilities, Player player) {
        if (player != null) {
            LazyOptional cap = player.getCapability(MorphCapabilityAttacher.MORPH_CAP);
            if (cap.isPresent()) {
                IMorphCapability resolved = (IMorphCapability)cap.resolve().get();
                MorphItem aboutToMorphTo = null;
                List<Ability> oldAbilities = resolved.getCurrentAbilities();
                MorphItem oldMorphItem = resolved.getCurrentMorph().orElse(null);
                if (morphItem.isPresent()) {
                    aboutToMorphTo = morphItem.get();
                } else if (morphIndex.isPresent()) {
                    aboutToMorphTo = resolved.getMorphList().getMorphArrayList().get(morphIndex.get());
                }
                MinecraftForge.EVENT_BUS.post((Event)new PlayerMorphEvent.Client.Pre(player, resolved, aboutToMorphTo));
                IRenderDataCapability renderDataCap = (IRenderDataCapability)player.getCapability(RenderDataCapabilityProvider.RENDER_CAP).resolve().get();
                Entity cachedEntityOld = renderDataCap.getOrCreateCachedEntity(player);
                ArrayList<IEntitySynchronizer> synchronizersOld = EntitySynchronizerRegistry.getSynchronizersForEntity(cachedEntityOld);
                if (cachedEntityOld == null) {
                    cachedEntityOld = player;
                    synchronizersOld.clear();
                }
                ArrayList<Ability> resolvedAbilities = new ArrayList<Ability>();
                for (String name : abilities) {
                    ResourceLocation resourceLocation = new ResourceLocation(name);
                    Ability foundAbility = (Ability)BMorphMod.DYNAMIC_ABILITY_REGISTRY.getEntry(resourceLocation);
                    if (foundAbility == null) {
                        LOGGER.warn(MessageFormat.format("The ability {0} is not present on the client. Ignoring this entry.", resourceLocation));
                        continue;
                    }
                    resolvedAbilities.add(foundAbility);
                }
                resolved.deapplyAbilities(aboutToMorphTo, resolvedAbilities);
                if (morphIndex.isPresent()) {
                    resolved.setMorph(morphIndex.get());
                } else if (morphItem.isPresent()) {
                    resolved.setMorph(morphItem.get());
                } else {
                    resolved.demorph();
                }
                MorphItem javaSucks = aboutToMorphTo;
                resolved.setCurrentAbilities(resolvedAbilities);
                DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> RenderHandler.onBuildNewEntity(player, resolved, javaSucks));
                resolved.applyAbilities(oldMorphItem, oldAbilities == null ? Arrays.asList(new Ability[0]) : oldAbilities);
                MinecraftForge.EVENT_BUS.post((Event)new PlayerMorphEvent.Client.Post(player, resolved, aboutToMorphTo));
                Entity cachedEntityNew = renderDataCap.getOrCreateCachedEntity(player);
                ArrayList<IEntitySynchronizer> synchronizersNew = EntitySynchronizerRegistry.getSynchronizersForEntity(cachedEntityNew);
                if (cachedEntityNew == null) {
                    cachedEntityNew = player;
                    synchronizersNew.clear();
                }
                renderDataCap.setAnimation(Optional.of(new ScaleAnimation(player, cachedEntityOld, synchronizersOld, cachedEntityNew, synchronizersNew, 20)));
            } else {
                System.out.println("Could not synchronize data, as the morph cap is not created yet.");
            }
        }
    }
}

