/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.morph;

import de.budschie.bmorph.morph.MorphItem;
import de.budschie.bmorph.network.MainNetworkChannel;
import de.budschie.bmorph.network.VisualMorphSynchronizer;
import java.util.HashMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.PacketDistributor;

public class VisualMorphDataRegistry {
    private HashMap<ResourceLocation, VisualMorphData> visualMorphDataRegistry = new HashMap();

    public void addVisualMorphData(VisualMorphData visualMorphData) {
        if (this.visualMorphDataRegistry.containsKey(visualMorphData.getRegistryName())) {
            throw new IllegalArgumentException(String.format("The key %s is already registered.", visualMorphData.getRegistryName()));
        }
        this.visualMorphDataRegistry.put(visualMorphData.getRegistryName(), visualMorphData);
    }

    public VisualMorphData getDataForMorph(ResourceLocation morph) {
        return this.visualMorphDataRegistry.get(morph);
    }

    public VisualMorphData getDataForMorph(MorphItem morphItem) {
        return this.getDataForMorph(morphItem.getEntityType().getRegistryName());
    }

    public void clear() {
        this.visualMorphDataRegistry.clear();
    }

    public void syncWithClient(ServerPlayer client) {
        if (!this.visualMorphDataRegistry.isEmpty()) {
            MainNetworkChannel.INSTANCE.send(PacketDistributor.PLAYER.with(() -> client), (Object)new VisualMorphSynchronizer.VisualMorphPacket(this.visualMorphDataRegistry.values()));
        }
    }

    public void syncWithClients() {
        if (!this.visualMorphDataRegistry.isEmpty()) {
            MainNetworkChannel.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new VisualMorphSynchronizer.VisualMorphPacket(this.visualMorphDataRegistry.values()));
        }
    }

    public static class VisualMorphData {
        private float scale;
        private ResourceLocation registryName;

        public VisualMorphData(float scale) {
            this.scale = scale;
        }

        public float getScale() {
            return this.scale;
        }

        public void setRegistryName(ResourceLocation registryName) {
            this.registryName = registryName;
        }

        public ResourceLocation getRegistryName() {
            return this.registryName;
        }
    }
}

