/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.morph.fallback;

import de.budschie.bmorph.morph.MorphItem;
import de.budschie.bmorph.morph.MorphManagerHandlers;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public class FallbackMorphItem
extends MorphItem {
    private CompoundTag entityData;
    private EntityType<?> entityType;

    public FallbackMorphItem(CompoundTag entityData, EntityType<?> entityType) {
        super("fallback_morph_item");
        this.entityData = entityData;
        this.entityType = entityType;
        entityData.m_128359_("id", entityType.getRegistryName().toString());
    }

    public FallbackMorphItem(EntityType<?> entityType) {
        this(new CompoundTag(), entityType);
    }

    public FallbackMorphItem() {
        super("fallback_morph_item");
    }

    @Override
    public EntityType<?> getEntityType() {
        return this.entityType;
    }

    @Override
    public Entity createEntity(Level world) {
        Entity entityLoaded = EntityType.m_20645_((CompoundTag)this.entityData, (Level)world, entity -> entity);
        if (entityLoaded == null) {
            throw new NullPointerException("The morph item \"" + this.entityType.getRegistryName().toString() + "\" could *NOT* be initialized, thus being null now.");
        }
        return entityLoaded;
    }

    @Override
    public void deserializeAdditional(CompoundTag nbt) {
        this.entityType = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(nbt.m_128461_("id")));
        this.entityData = nbt;
    }

    @Override
    public CompoundTag serializeAdditional() {
        return this.entityData;
    }

    public int hashCode() {
        return MorphManagerHandlers.FALLBACK.hashCodeFor(this);
    }

    public boolean equals(Object obj) {
        if (obj instanceof FallbackMorphItem) {
            FallbackMorphItem casted = (FallbackMorphItem)obj;
            return MorphManagerHandlers.FALLBACK.equalsFor(this, casted);
        }
        return false;
    }
}

