/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.morph.fallback;

import de.budschie.bmorph.events.MorphCreatedFromEntityEvent;
import de.budschie.bmorph.json_integration.JsonMorphNBTHandler;
import de.budschie.bmorph.json_integration.NBTPath;
import de.budschie.bmorph.morph.IMorphManager;
import de.budschie.bmorph.morph.fallback.FallbackMorphItem;
import de.budschie.bmorph.morph.fallback.IMorphNBTHandler;
import de.budschie.bmorph.morph.functionality.data_transformers.DataTransformer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.BiPredicate;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.Event;

public class FallbackMorphManager
implements IMorphManager<FallbackMorphItem, Void> {
    public static final JsonMorphNBTHandler DEFAULT_HANDLER = new JsonMorphNBTHandler(new CompoundTag(), new NBTPath[]{new NBTPath("CustomName")}, new ArrayList<LazyOptional<DataTransformer>>());
    private HashMap<EntityType<?>, IMorphNBTHandler> dataHandlers = new HashMap();

    @Override
    public boolean doesManagerApplyTo(EntityType<?> type) {
        return true;
    }

    @Override
    public FallbackMorphItem createMorphFromEntity(Entity entity) {
        IMorphNBTHandler handler = this.dataHandlers.get(entity.m_6095_());
        CompoundTag tagIn = entity.serializeNBT();
        CompoundTag tagOut = handler == null ? DEFAULT_HANDLER.applyDefaultNBTData(tagIn) : handler.applyDefaultNBTData(tagIn);
        MorphCreatedFromEntityEvent event = new MorphCreatedFromEntityEvent(tagIn, tagOut, entity);
        MinecraftForge.EVENT_BUS.post((Event)event);
        tagOut = event.getTagOut();
        return new FallbackMorphItem(tagOut, entity.m_6095_());
    }

    @Override
    public FallbackMorphItem createMorph(EntityType<?> entity, CompoundTag nbt, Void data, boolean forceNBT) {
        IMorphNBTHandler handler = this.dataHandlers.get(entity);
        if (!forceNBT) {
            nbt = handler != null ? handler.applyDefaultNBTData(nbt) : DEFAULT_HANDLER.applyDefaultNBTData(nbt);
        }
        return new FallbackMorphItem(nbt, entity);
    }

    @Override
    public FallbackMorphItem createMorph(EntityType<?> entity, Void data) {
        IMorphNBTHandler handler = this.dataHandlers.get(entity);
        if (handler == null) {
            CompoundTag nbt = new CompoundTag();
            return new FallbackMorphItem(DEFAULT_HANDLER.applyDefaultNBTData(nbt), entity);
        }
        CompoundTag nbt = new CompoundTag();
        return new FallbackMorphItem(handler.applyDefaultNBTData(nbt), entity);
    }

    @Override
    public boolean equalsFor(FallbackMorphItem item1, FallbackMorphItem item2) {
        if (item1 == null && item2 == null) {
            return true;
        }
        if (item1 == null || item2 == null) {
            return false;
        }
        if (item1.getEntityType() != item2.getEntityType()) {
            return false;
        }
        IMorphNBTHandler handler = this.dataHandlers.get(item1.getEntityType());
        return handler == null ? DEFAULT_HANDLER.areEquals(item1, item2) : handler.areEquals(item1, item2);
    }

    @Override
    public int hashCodeFor(FallbackMorphItem item) {
        IMorphNBTHandler handler = this.dataHandlers.get(item.getEntityType());
        if (handler == null) {
            return DEFAULT_HANDLER.getHashCodeFor(item);
        }
        return handler.getHashCodeFor(item);
    }

    public void addDataHandler(EntityType<?> entityType, IMorphNBTHandler dataHandler) {
        this.dataHandlers.put(entityType, dataHandler);
    }

    public void setDataHandlers(HashMap<EntityType<?>, IMorphNBTHandler> dataHandlers) {
        this.dataHandlers = dataHandlers;
    }

    public static class SpecialDataHandler
    implements IMorphNBTHandler {
        private BiPredicate<FallbackMorphItem, FallbackMorphItem> equalsMethod;
        private Function<FallbackMorphItem, Integer> hashFunction;
        private Function<CompoundTag, CompoundTag> defaultApplier;

        public SpecialDataHandler(BiPredicate<FallbackMorphItem, FallbackMorphItem> equalsMethod, Function<FallbackMorphItem, Integer> hashFunction, Function<CompoundTag, CompoundTag> defaultApplier) {
            this.equalsMethod = equalsMethod;
            this.hashFunction = hashFunction;
            this.defaultApplier = defaultApplier;
        }

        @Override
        public boolean areEquals(FallbackMorphItem item1, FallbackMorphItem item2) {
            return this.equalsMethod.test(item1, item2);
        }

        @Override
        public int getHashCodeFor(FallbackMorphItem item) {
            return this.hashFunction.apply(item);
        }

        @Override
        public CompoundTag applyDefaultNBTData(CompoundTag in) {
            return this.defaultApplier.apply(in);
        }
    }
}

