/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.morph.functionality;

import de.budschie.bmorph.capabilities.AbilitySerializationContext;
import de.budschie.bmorph.morph.MorphItem;
import de.budschie.bmorph.morph.functionality.configurable.ConfigurableAbility;
import de.budschie.bmorph.util.IDynamicRegistryObject;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class Ability
implements IDynamicRegistryObject {
    private final Logger LOGGER = LogManager.getLogger();
    protected HashSet<UUID> trackedPlayers = new HashSet();
    private ResourceLocation resourceLocation;
    private ConfigurableAbility<? extends Ability> configurableAbility;

    @Deprecated(since="1.18.1-3.0.0", forRemoval=true)
    public void enableAbility(Player player, MorphItem enabledItem) {
    }

    public void enableAbility(Player player, MorphItem enabledItem, MorphItem oldMorph, List<Ability> oldAbilities, AbilityChangeReason reason) {
        this.enableAbility(player, enabledItem);
        if (this.isAbleToReceiveEvents()) {
            this.trackedPlayers.add(player.m_142081_());
        }
    }

    @Deprecated(since="1.18.1-3.0.0", forRemoval=true)
    public void disableAbility(Player player, MorphItem disabledItem) {
    }

    public void disableAbility(Player player, MorphItem disabledItem, MorphItem newMorph, List<Ability> newAbilities, AbilityChangeReason reason) {
        this.disableAbility(player, disabledItem);
    }

    public void removePlayerReferences(Player playerRefToRemove) {
        if (this.isAbleToReceiveEvents()) {
            this.trackedPlayers.remove(playerRefToRemove.m_142081_());
        }
    }

    public void onUsedAbility(Player player, MorphItem currentMorph) {
    }

    public void onRegister() {
        if (this.isAbleToReceiveEvents()) {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
    }

    public void onUnregister() {
        if (this.isAbleToReceiveEvents()) {
            MinecraftForge.EVENT_BUS.unregister((Object)this);
        }
    }

    @Override
    public ResourceLocation getResourceLocation() {
        return this.resourceLocation;
    }

    @Override
    public void setResourceLocation(ResourceLocation resourceLocation) {
        this.resourceLocation = resourceLocation;
    }

    public ConfigurableAbility<? extends Ability> getConfigurableAbility() {
        return this.configurableAbility;
    }

    public void setConfigurableAbility(ConfigurableAbility<?> configurableAbility) {
        this.configurableAbility = configurableAbility;
    }

    public boolean isAbleToReceiveEvents() {
        return false;
    }

    public boolean isTracked(Entity entity) {
        return this.trackedPlayers.contains(entity.m_142081_());
    }

    public int hashCode() {
        return this.resourceLocation.hashCode();
    }

    public boolean equals(Object obj) {
        Ability otherAbility;
        return obj instanceof Ability && (otherAbility = (Ability)obj).getResourceLocation().equals((Object)this.getResourceLocation());
    }

    public void serialize(Player player, AbilitySerializationContext context, boolean canSaveTransientData) {
        context.deleteSerializationObjectForAbility(this);
    }

    public void deserialize(Player player, AbilitySerializationContext context) {
    }

    public static enum AbilityChangeReason {
        MORPHED,
        DYNAMIC,
        LOGGED_OUT;

    }
}

