/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.morph.functionality;

import de.budschie.bmorph.capabilities.IMorphCapability;
import de.budschie.bmorph.capabilities.MorphCapabilityAttacher;
import de.budschie.bmorph.main.ServerSetup;
import de.budschie.bmorph.morph.functionality.Ability;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class PassiveTickAbility
extends Ability {
    private int updateDuration = 0;
    private int lastUpdate = 0;
    private BiConsumer<Player, IMorphCapability> handleUpdate;

    public PassiveTickAbility(int updateDuration, BiConsumer<Player, IMorphCapability> handleUpdate) {
        this.updateDuration = updateDuration;
        this.handleUpdate = handleUpdate;
    }

    public int getUpdateDuration() {
        return this.updateDuration;
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        int tickCounter;
        if (event.phase == TickEvent.Phase.START && (tickCounter = ServerSetup.server.m_129921_()) >= this.lastUpdate + this.updateDuration) {
            this.lastUpdate = tickCounter;
            for (UUID uuid : this.trackedPlayers) {
                LazyOptional cap;
                ServerPlayer player = ServerSetup.server.m_6846_().m_11259_(uuid);
                if (player == null || !(cap = player.getCapability(MorphCapabilityAttacher.MORPH_CAP)).isPresent()) continue;
                IMorphCapability resolved = (IMorphCapability)cap.resolve().get();
                this.handleUpdate.accept((Player)player, resolved);
            }
        }
    }

    @Override
    public boolean isAbleToReceiveEvents() {
        return true;
    }
}

