/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.morph.functionality;

import de.budschie.bmorph.capabilities.AbilitySerializationContext;
import de.budschie.bmorph.morph.functionality.Ability;
import de.budschie.bmorph.util.BudschieUtils;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;

public abstract class StunAbility
extends Ability {
    private int stun;
    private HashMap<UUID, Integer> delayHashMap = new HashMap();

    public StunAbility(int stun) {
        this.stun = stun;
    }

    public int getStun() {
        return this.stun;
    }

    public int getStunTimeLeftFor(Player player) {
        return this.delayHashMap.containsKey(player.m_142081_()) ? this.delayHashMap.get(player.m_142081_()) - BudschieUtils.getUniversalTickTime() : 0;
    }

    public boolean isCurrentlyStunned(UUID player) {
        return this.delayHashMap.getOrDefault(player, 0) > BudschieUtils.getUniversalTickTime();
    }

    @Override
    public void removePlayerReferences(Player playerRefToRemove) {
        super.removePlayerReferences(playerRefToRemove);
        this.delayHashMap.remove(playerRefToRemove.m_142081_());
    }

    public void stun(UUID player) {
        this.delayHashMap.put(player, BudschieUtils.getUniversalTickTime() + this.stun);
    }

    public void stun(UUID player, int nonDefaultStunTime) {
        this.delayHashMap.put(player, BudschieUtils.getUniversalTickTime() + nonDefaultStunTime);
    }

    @Override
    public void serialize(Player player, AbilitySerializationContext context, boolean canSaveTransientData) {
        super.serialize(player, context, canSaveTransientData);
        context.getOrCreateSerializationObjectForAbility(this).getOrCreatePersistentTag().m_128405_("stun_stunned_for", this.getStunTimeLeftFor(player));
    }

    @Override
    public void deserialize(Player player, AbilitySerializationContext context) {
        super.deserialize(player, context);
        AbilitySerializationContext.AbilitySerializationObject object = context.getSerializationObjectForAbilityOrNull(this);
        if (object != null && object.getPersistentTag().isPresent()) {
            CompoundTag persistentTag = object.getPersistentTag().get();
            this.stun(player.m_142081_(), persistentTag.m_128451_("stun_stunned_for"));
        }
    }
}

