/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.morph.functionality.codec_addition;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.budschie.bmorph.util.ParticleCloudInstance;
import de.budschie.bmorph.util.SoundInstance;
import java.util.Arrays;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class AudioVisualEffect {
    public static final Codec<AudioVisualEffect> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SoundInstance.CODEC.listOf().optionalFieldOf("sounds", (Object)Lists.newArrayList()).forGetter(AudioVisualEffect::getSounds), (App)ParticleCloudInstance.CODEC.listOf().optionalFieldOf("particles", (Object)Lists.newArrayList()).forGetter(AudioVisualEffect::getParticleClouds)).apply((Applicative)instance, AudioVisualEffect::new));
    private List<SoundInstance> sounds;
    private List<ParticleCloudInstance> particleClouds;

    public AudioVisualEffect(List<SoundInstance> sounds, List<ParticleCloudInstance> particleClouds) {
        this.sounds = sounds;
        this.particleClouds = particleClouds;
    }

    public AudioVisualEffect() {
        this(Arrays.asList(new SoundInstance[0]), Arrays.asList(new ParticleCloudInstance[0]));
    }

    public List<ParticleCloudInstance> getParticleClouds() {
        return this.particleClouds;
    }

    public List<SoundInstance> getSounds() {
        return this.sounds;
    }

    public void playEffectClient(Level level, Vec3 at) {
        for (SoundInstance sound : this.sounds) {
            sound.playSound(at.f_82479_, at.f_82480_, at.f_82481_, level);
        }
        for (ParticleCloudInstance pCloud : this.particleClouds) {
            pCloud.placeParticleCloudOnClient(at);
        }
    }

    public void playEffectServer(ServerLevel level, Vec3 at) {
        for (SoundInstance sound : this.sounds) {
            sound.playSound(at.f_82479_, at.f_82480_, at.f_82481_, (Level)level);
        }
        for (ParticleCloudInstance pCloud : this.particleClouds) {
            pCloud.placeParticleCloudOnServer(level, at);
        }
    }

    public void playEffect(Level level, Vec3 at) {
        if (level.m_5776_()) {
            this.playEffectClient(level, at);
        } else {
            this.playEffectServer((ServerLevel)level, at);
        }
    }

    public void playEffect(Entity at) {
        this.playEffect(at.f_19853_, at.m_20182_());
    }
}

