/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.morph.functionality.codec_addition;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.budschie.bmorph.json_integration.ability_groups.AbilityGroupRegistry;
import de.budschie.bmorph.main.BMorphMod;
import de.budschie.bmorph.main.ServerSetup;
import de.budschie.bmorph.morph.LazyRegistryWrapper;
import de.budschie.bmorph.morph.LazyTag;
import de.budschie.bmorph.morph.functionality.Ability;
import de.budschie.bmorph.morph.functionality.codec_addition.CommandProvider;
import de.budschie.bmorph.morph.functionality.data_transformers.DataTransformer;
import de.budschie.bmorph.util.DynamicRegistry;
import de.budschie.bmorph.util.IDynamicRegistryObject;
import java.text.MessageFormat;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.BossEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.tags.ITag;

public class ModCodecs {
    public static final Codec<SoundEvent> SOUND_EVENT_CODEC = Codec.of((Encoder)new Encoder<SoundEvent>(){

        public <T> DataResult<T> encode(SoundEvent input, DynamicOps<T> ops, T prefix) {
            return DataResult.success((Object)ops.createString(input.getRegistryName().toString()));
        }
    }, (Decoder)new Decoder<SoundEvent>(){

        public <T> DataResult<Pair<SoundEvent, T>> decode(DynamicOps<T> ops, T input) {
            DataResult id = ops.getStringValue(input);
            if (id.result().isPresent()) {
                SoundEvent soundEvent = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation((String)id.result().get()));
                if (soundEvent == null) {
                    return SoundEvent.f_11655_.decode(ops, input);
                }
                return DataResult.success((Object)Pair.of((Object)soundEvent, input));
            }
            return DataResult.error((String)((DataResult.PartialResult)id.error().get()).message());
        }
    });
    public static final Codec<Attribute> ATTRIBUTE = ModCodecs.getForgeRegistryCodec(arg_0 -> ((IForgeRegistry)ForgeRegistries.ATTRIBUTES).getValue(arg_0));
    public static final Codec<MobEffect> EFFECTS = ModCodecs.getForgeRegistryCodec(arg_0 -> ((IForgeRegistry)ForgeRegistries.MOB_EFFECTS).getValue(arg_0));
    public static final Codec<EntityType<?>> ENTITIES = ModCodecs.getForgeRegistryCodec(arg_0 -> ((IForgeRegistry)ForgeRegistries.ENTITIES).getValue(arg_0));
    public static final Codec<Block> BLOCKS = ModCodecs.getForgeRegistryCodec(arg_0 -> ((IForgeRegistry)ForgeRegistries.BLOCKS).getValue(arg_0));
    public static final Codec<Fluid> FLUIDS = ModCodecs.getForgeRegistryCodec(arg_0 -> ((IForgeRegistry)ForgeRegistries.FLUIDS).getValue(arg_0));
    public static final Codec<ParticleType<?>> PARTICLE_TYPE = ModCodecs.getForgeRegistryCodec(arg_0 -> ((IForgeRegistry)ForgeRegistries.PARTICLE_TYPES).getValue(arg_0));
    public static final Codec<CommandProvider.Selector> SELECTOR_ENUM = ModCodecs.getEnumCodec(CommandProvider.Selector.class, CommandProvider.Selector::values);
    public static final Codec<Direction> DIRECTION_ENUM = ModCodecs.getEnumCodec(Direction.class, Direction::values);
    public static final Codec<BossEvent.BossBarColor> BOSSBAR_COLOR_ENUM = ModCodecs.getEnumCodec(BossEvent.BossBarColor.class, BossEvent.BossBarColor::values);
    public static final Codec<BossEvent.BossBarOverlay> BOSSBAR_OVERLAY_ENUM = ModCodecs.getEnumCodec(BossEvent.BossBarOverlay.class, BossEvent.BossBarOverlay::values);
    public static final Codec<LazyTag<Block>> LAZY_BLOCK_TAGS = ModCodecs.getLazyTagCodec(rl -> ForgeRegistries.BLOCKS.tags().getTag(TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)rl)));
    public static final Codec<LazyTag<Item>> LAZY_ITEM_TAGS = ModCodecs.getLazyTagCodec(rl -> ForgeRegistries.ITEMS.tags().getTag(TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)rl)));
    public static final Codec<LazyOptional<Ability>> ABILITY = ModCodecs.getLazyDynamicRegistry(() -> BMorphMod.DYNAMIC_ABILITY_REGISTRY, "ability", Optional.empty());
    public static final Codec<LazyOptional<AbilityGroupRegistry.AbilityGroup>> ABILITY_GROUP = ModCodecs.getLazyDynamicRegistry(() -> BMorphMod.ABILITY_GROUPS, "ability group", Optional.of("#"));
    public static final Codec<LazyOptional<DataTransformer>> DATA_TRANSFORMER = ModCodecs.getLazyDynamicRegistry(() -> BMorphMod.DYNAMIC_DATA_TRANSFORMER_REGISTRY, "data transformer", Optional.empty());
    public static final Codec<LazyRegistryWrapper<LootItemCondition>> PREDICATE = ModCodecs.getLazyMCRegistryObjectCodec(rl -> ServerSetup.server.m_129899_().m_79252_(rl), "predicate");
    public static final Codec<Tag> NBT_TAG = Codec.STRING.flatXmap(str -> {
        Tag tag;
        try {
            tag = new TagParser(new StringReader(str)).m_129371_();
        }
        catch (CommandSyntaxException ex) {
            return DataResult.error((String)("Could not parse NBT data: " + ex.getMessage()));
        }
        return DataResult.success((Object)tag);
    }, tag -> DataResult.success((Object)tag.toString()));
    public static final Codec<CompoundTag> NBT_COMPOUND_TAG = Codec.STRING.flatXmap(str -> {
        CompoundTag tag;
        try {
            tag = new TagParser(new StringReader(str)).m_129373_();
        }
        catch (CommandSyntaxException ex) {
            return DataResult.error((String)("Could not parse NBT compound data: " + ex.getMessage()));
        }
        return DataResult.success((Object)tag);
    }, tag -> DataResult.success((Object)tag.toString()));
    public static final Codec<Vec3> VECTOR_3D = RecordCodecBuilder.create(instance -> instance.group((App)Codec.DOUBLE.fieldOf("x").forGetter(inst -> inst.f_82479_), (App)Codec.DOUBLE.fieldOf("y").forGetter(inst -> inst.f_82480_), (App)Codec.DOUBLE.fieldOf("z").forGetter(inst -> inst.f_82481_)).apply((Applicative)instance, Vec3::new));
    public static final Codec<Vec3i> VECTOR_3D_I = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("x").forGetter(inst -> inst.m_123341_()), (App)Codec.INT.fieldOf("y").forGetter(inst -> inst.m_123342_()), (App)Codec.INT.fieldOf("z").forGetter(inst -> inst.m_123343_())).apply((Applicative)instance, Vec3i::new));
    public static final Codec<MobEffectInstance> EFFECT_INSTANCE = RecordCodecBuilder.create(instance -> instance.group((App)EFFECTS.fieldOf("potion_effect").forGetter(MobEffectInstance::m_19544_), (App)Codec.INT.optionalFieldOf("duration", (Object)40).forGetter(MobEffectInstance::m_19557_), (App)Codec.INT.optionalFieldOf("amplifier", (Object)0).forGetter(MobEffectInstance::m_19564_), (App)Codec.BOOL.optionalFieldOf("ambient", (Object)false).forGetter(MobEffectInstance::m_19571_), (App)Codec.BOOL.optionalFieldOf("show_particles", (Object)false).forGetter(MobEffectInstance::m_19572_), (App)Codec.BOOL.optionalFieldOf("show_icon", (Object)true).forGetter(MobEffectInstance::m_19575_)).apply((Applicative)instance, MobEffectInstance::new));
    public static final Codec<CommandProvider> COMMAND_PROVIDER = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("command").forGetter(CommandProvider::getCommand), (App)SELECTOR_ENUM.optionalFieldOf("selector", (Object)CommandProvider.Selector.SELF).forGetter(CommandProvider::getSelector)).apply((Applicative)instance, CommandProvider::new));
    public static final Codec<AttributeModifier.Operation> OPERATION = new Codec<AttributeModifier.Operation>(){

        public <T> DataResult<T> encode(AttributeModifier.Operation input, DynamicOps<T> ops, T prefix) {
            return DataResult.success((Object)ops.createString(input.name().toLowerCase()));
        }

        public <T> DataResult<Pair<AttributeModifier.Operation, T>> decode(DynamicOps<T> ops, T input) {
            String str = (String)ops.getStringValue(input).result().get();
            AttributeModifier.Operation op = AttributeModifier.Operation.valueOf((String)str.toUpperCase());
            if (op == null) {
                return DataResult.error((String)String.format("The Operation %s is unknown. Here is a list of valid operations: %s", str, Stream.of(AttributeModifier.Operation.values()).map(operation -> operation.name().toLowerCase()).collect(Collectors.joining(", "))));
            }
            return DataResult.success((Object)Pair.of((Object)op, input));
        }
    };

    public static final <R extends IDynamicRegistryObject, D extends DynamicRegistry<R, ?>> Codec<LazyOptional<R>> getLazyDynamicRegistry(final Supplier<D> registry, final String typeName, final Optional<String> idPrefix) {
        return new Codec<LazyOptional<R>>(){

            public <T> DataResult<T> encode(LazyOptional<R> input, DynamicOps<T> ops, T prefix) {
                if (input.isPresent()) {
                    return DataResult.success((Object)ops.createString(idPrefix.orElse("") + ((IDynamicRegistryObject)input.resolve().get()).getResourceLocation().toString()));
                }
                return DataResult.error((String)("The given " + typeName + " entry could not be encoded because it is null."));
            }

            public <T> DataResult<Pair<LazyOptional<R>, T>> decode(DynamicOps<T> ops, T input) {
                DataResult rl = ops.getStringValue(input);
                if (rl.result().isPresent()) {
                    String str = (String)rl.result().get();
                    if (idPrefix.isPresent()) {
                        if (str.startsWith((String)idPrefix.get())) {
                            str = str.substring(((String)idPrefix.get()).length());
                        } else {
                            return DataResult.error((String)MessageFormat.format("The given registry entry id {0} did not have {1} as its prefix.", str, idPrefix.get()));
                        }
                    }
                    ResourceLocation result = new ResourceLocation((String)rl.result().get());
                    return DataResult.success((Object)Pair.of((Object)LazyOptional.of(() -> 3.lambda$decode$0((Supplier)registry, result)), input));
                }
                return DataResult.error((String)((DataResult.PartialResult)rl.error().get()).message());
            }

            private static /* synthetic */ IDynamicRegistryObject lambda$decode$0(Supplier registry2, ResourceLocation result) {
                return ((DynamicRegistry)registry2.get()).getEntry(result);
            }
        };
    }

    public static final <T> Codec<LazyRegistryWrapper<T>> getLazyMCRegistryObjectCodec(Function<ResourceLocation, T> toObject, String name) {
        return ResourceLocation.f_135803_.flatXmap(resourceLocation -> {
            if (resourceLocation == null) {
                return DataResult.error((String)("The resource location was null; thus there was no " + name + " present."));
            }
            return DataResult.success(new LazyRegistryWrapper((ResourceLocation)resourceLocation, toObject));
        }, fromLazyOptional -> DataResult.success((Object)fromLazyOptional.getResourceLocation()));
    }

    public static final <T> Codec<LazyTag<T>> getLazyTagCodec(Function<ResourceLocation, ITag<T>> toObject) {
        return ResourceLocation.f_135803_.flatXmap(resourceLocation -> {
            if (resourceLocation == null) {
                return DataResult.error((String)"The resource location was null; thus there was no tag present.");
            }
            return DataResult.success(new LazyTag((ResourceLocation)resourceLocation, toObject));
        }, fromLazyOptional -> DataResult.success((Object)fromLazyOptional.getResourceLocation()));
    }

    public static final <A extends Enum<A>> Codec<A> getEnumCodec(final Class<A> clazz, final Supplier<A[]> values) {
        return new Codec<A>(){

            public <T> DataResult<T> encode(A input, DynamicOps<T> ops, T prefix) {
                return DataResult.success((Object)ops.createString(((Enum)input).name().toLowerCase()));
            }

            public <T> DataResult<Pair<A, T>> decode(DynamicOps<T> ops, T input) {
                String str = (String)ops.getStringValue(input).result().get();
                boolean hasEnum = true;
                Object enumParsed = null;
                try {
                    enumParsed = Enum.valueOf(clazz, str.toUpperCase());
                }
                catch (IllegalArgumentException exception) {
                    hasEnum = false;
                }
                if (hasEnum) {
                    return DataResult.success((Object)Pair.of(enumParsed, input));
                }
                System.out.println(String.format("The %s %s is unknown. Here is a list of valid operations: %s", clazz.getName(), str, Stream.of((Enum[])values.get()).map(validEnum -> validEnum.name().toLowerCase()).collect(Collectors.joining(", "))));
                return DataResult.error((String)String.format("The %s %s is unknown. Here is a list of valid operations: %s", clazz.getName(), str, Stream.of((Enum[])values.get()).map(validEnum -> validEnum.name().toLowerCase()).collect(Collectors.joining(", "))));
            }
        };
    }

    private static <A extends IForgeRegistryEntry<A>> Codec<A> getForgeRegistryCodec(final Function<ResourceLocation, A> registryRetrieval) {
        return new Codec<A>(){

            public <T> DataResult<T> encode(A input, DynamicOps<T> ops, T prefix) {
                return DataResult.success((Object)ops.createString(input.getRegistryName().toString()));
            }

            public <T> DataResult<Pair<A, T>> decode(DynamicOps<T> ops, T input) {
                DataResult rl = ops.getStringValue(input);
                if (rl.result().isPresent()) {
                    ResourceLocation result = new ResourceLocation((String)rl.result().get());
                    IForgeRegistryEntry retrieved = (IForgeRegistryEntry)registryRetrieval.apply(result);
                    if (retrieved == null) {
                        return DataResult.error((String)String.format("The resource location %s did not yield any registry entry when tried to resolve into an actual instance.", result));
                    }
                    return DataResult.success((Object)Pair.of((Object)retrieved, input));
                }
                return DataResult.error((String)((DataResult.PartialResult)rl.error().get()).message());
            }
        };
    }
}

