/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.morph.functionality.configurable;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.budschie.bmorph.capabilities.AbilitySerializationContext;
import de.budschie.bmorph.json_integration.ability_groups.AbilityGroupRegistry;
import de.budschie.bmorph.main.ServerSetup;
import de.budschie.bmorph.morph.LazyRegistryWrapper;
import de.budschie.bmorph.morph.MorphItem;
import de.budschie.bmorph.morph.MorphUtil;
import de.budschie.bmorph.morph.functionality.Ability;
import de.budschie.bmorph.morph.functionality.codec_addition.ModCodecs;
import de.budschie.bmorph.util.BudschieUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ActivateAbilityIf
extends Ability {
    public static final Codec<ActivateAbilityIf> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.either(ModCodecs.ABILITY, ModCodecs.ABILITY_GROUP).fieldOf("ability").forGetter(ActivateAbilityIf::getAbilityToActivate), (App)ModCodecs.PREDICATE.listOf().listOf().optionalFieldOf("predicates", Arrays.asList(new List[0])).forGetter(ActivateAbilityIf::getPredicates), (App)Codec.INT.optionalFieldOf("lazy_ticks", (Object)0).forGetter(ActivateAbilityIf::getLazyTicks), (App)Codec.BOOL.optionalFieldOf("immediate_restore", (Object)false).forGetter(ActivateAbilityIf::shouldDoImmediateRestore), (App)Codec.BOOL.optionalFieldOf("immediate_reset", (Object)false).forGetter(ActivateAbilityIf::shouldDoImmediateReset)).apply((Applicative)instance, ActivateAbilityIf::new));
    private Either<LazyOptional<Ability>, LazyOptional<AbilityGroupRegistry.AbilityGroup>> abilityToActivate;
    private List<List<LazyRegistryWrapper<LootItemCondition>>> predicates;
    private HashMap<UUID, PlayerTimeHelper> playerEnableCount = new HashMap();
    private HashSet<UUID> playersWithAbilities = new HashSet();
    private int lazyTicks;
    private boolean immediateRestore;
    private boolean immediateReset;

    public ActivateAbilityIf(Either<LazyOptional<Ability>, LazyOptional<AbilityGroupRegistry.AbilityGroup>> abilityToActivate, List<List<LazyRegistryWrapper<LootItemCondition>>> predicates, int lazyTicks, boolean immediateRestore, boolean immediateReset) {
        this.abilityToActivate = abilityToActivate;
        this.predicates = predicates;
        this.lazyTicks = lazyTicks;
        this.immediateRestore = immediateRestore;
        this.immediateReset = immediateReset;
    }

    @Override
    public void disableAbility(Player player, MorphItem disabledItem, MorphItem newMorph, List<Ability> newAbilities, Ability.AbilityChangeReason reason) {
        super.disableAbility(player, disabledItem, newMorph, newAbilities, reason);
        if (this.playersWithAbilities.contains(player.m_142081_())) {
            this.disableAssociatedAbilities(player);
        }
    }

    @Override
    public void removePlayerReferences(Player playerRefToRemove) {
        super.removePlayerReferences(playerRefToRemove);
        this.playerEnableCount.remove(playerRefToRemove.m_142081_());
    }

    @Override
    public boolean isAbleToReceiveEvents() {
        return true;
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        UUID[] clonedTrackedPlayers;
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        for (UUID playerId : clonedTrackedPlayers = (UUID[])this.trackedPlayers.toArray(UUID[]::new)) {
            int currentPlayerTicks;
            LootContext.Builder predicateContext;
            ServerPlayer player = ServerSetup.server.m_6846_().m_11259_(playerId);
            LootItemCondition[][] resolved = BudschieUtils.resolveConditions(this.predicates);
            if (BudschieUtils.testPredicates(resolved, () -> ActivateAbilityIf.lambda$onServerTick$2(predicateContext = new LootContext.Builder((ServerLevel)player.f_19853_).m_78972_(LootContextParams.f_81460_, (Object)player.m_20182_()).m_78984_(LootContextParams.f_81455_, (Object)player)))) {
                this.incrementPlayerTicksIfPossible((Player)player);
                currentPlayerTicks = this.getCurrentPlayerTicks((Player)player);
                if (currentPlayerTicks >= this.lazyTicks && !this.playersWithAbilities.contains(playerId)) {
                    this.enableAssociatedAbilities((Player)player);
                    this.playersWithAbilities.add(playerId);
                }
                if (!this.immediateRestore || currentPlayerTicks <= 0 || currentPlayerTicks >= this.lazyTicks || !this.playersWithAbilities.contains(player.m_142081_())) continue;
                this.playerEnableCount.get((Object)player.m_142081_()).storedTime = this.lazyTicks;
                continue;
            }
            this.decrementPlayerTicksIfPossible((Player)player);
            currentPlayerTicks = this.getCurrentPlayerTicks((Player)player);
            if (currentPlayerTicks <= 0 && this.playersWithAbilities.contains(playerId)) {
                this.disableAssociatedAbilities((Player)player);
                this.playersWithAbilities.remove(playerId);
            }
            if (!this.immediateReset || currentPlayerTicks <= 0 || this.playersWithAbilities.contains(player.m_142081_())) continue;
            this.playerEnableCount.get((Object)player.m_142081_()).storedTime = 0;
        }
    }

    @Override
    public void serialize(Player player, AbilitySerializationContext context, boolean canSaveTransientData) {
        super.serialize(player, context, canSaveTransientData);
        if (canSaveTransientData && this.playerEnableCount.containsKey(player.m_142081_())) {
            context.getOrCreateSerializationObjectForAbility(this).createTransientTag().m_128405_("player_time_until_activation", this.playerEnableCount.get(player.m_142081_()).getStoredTime());
        }
    }

    @Override
    public void deserialize(Player player, AbilitySerializationContext context) {
        super.deserialize(player, context);
        AbilitySerializationContext.AbilitySerializationObject object = context.getSerializationObjectForAbilityOrNull(this);
        if (object != null && object.getTransientTag().isPresent() && object.getTransientTag().get().m_128441_("player_time_until_activation")) {
            PlayerTimeHelper helper = new PlayerTimeHelper();
            helper.storedTime = object.getTransientTag().get().m_128451_("player_time_until_activation");
            this.playerEnableCount.put(player.m_142081_(), helper);
        }
    }

    private void disableAssociatedAbilities(Player player) {
        MorphUtil.processCap(player, cap -> {
            this.abilityToActivate.ifLeft(leftAbility -> cap.deapplyAbility((Ability)leftAbility.resolve().get()));
            this.abilityToActivate.ifRight(rightAbilityGroup -> ((AbilityGroupRegistry.AbilityGroup)rightAbilityGroup.resolve().get()).getAbilities().forEach(ability -> cap.deapplyAbility((Ability)ability)));
        });
    }

    private void enableAssociatedAbilities(Player player) {
        MorphUtil.processCap(player, cap -> {
            this.abilityToActivate.ifLeft(leftAbility -> cap.applyAbility((Ability)leftAbility.resolve().get()));
            this.abilityToActivate.ifRight(rightAbilityGroup -> ((AbilityGroupRegistry.AbilityGroup)rightAbilityGroup.resolve().get()).getAbilities().forEach(ability -> cap.applyAbility((Ability)ability)));
        });
    }

    private void incrementPlayerTicksIfPossible(Player player) {
        this.playerEnableCount.computeIfAbsent(player.m_142081_(), uuid -> new PlayerTimeHelper());
        this.playerEnableCount.get(player.m_142081_()).incrementTime(this.lazyTicks);
    }

    private void decrementPlayerTicksIfPossible(Player player) {
        if (this.playerEnableCount.containsKey(player.m_142081_())) {
            PlayerTimeHelper helper = this.playerEnableCount.get(player.m_142081_());
            helper.decrementTime();
            if (helper.shouldBeDeleted()) {
                this.playerEnableCount.remove(player.m_142081_());
            }
        }
    }

    private int getCurrentPlayerTicks(Player player) {
        return this.playerEnableCount.containsKey(player.m_142081_()) ? this.playerEnableCount.get(player.m_142081_()).getStoredTime() : 0;
    }

    public Either<LazyOptional<Ability>, LazyOptional<AbilityGroupRegistry.AbilityGroup>> getAbilityToActivate() {
        return this.abilityToActivate;
    }

    public List<List<LazyRegistryWrapper<LootItemCondition>>> getPredicates() {
        return this.predicates;
    }

    public int getLazyTicks() {
        return this.lazyTicks;
    }

    public boolean shouldDoImmediateRestore() {
        return this.immediateRestore;
    }

    public boolean shouldDoImmediateReset() {
        return this.immediateReset;
    }

    private static /* synthetic */ LootContext lambda$onServerTick$2(LootContext.Builder predicateContext) {
        return predicateContext.m_78975_(LootContextParamSets.f_81412_);
    }

    public static class PlayerTimeHelper {
        private int storedTime = 0;

        public void incrementTime(int maxTime) {
            if (this.storedTime < maxTime) {
                ++this.storedTime;
            }
        }

        public void decrementTime() {
            --this.storedTime;
        }

        public boolean shouldBeDeleted() {
            return this.storedTime <= 0;
        }

        public int getStoredTime() {
            return this.storedTime;
        }
    }
}

