/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.morph.functionality.configurable;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.budschie.bmorph.morph.functionality.Ability;
import java.util.ArrayList;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class AttackYeetAbility
extends Ability {
    public static final Codec<AttackYeetAbility> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.optionalFieldOf("yeet_amount", (Object)Float.valueOf(1.0f)).forGetter(AttackYeetAbility::getYeetAmount)).apply((Applicative)instance, AttackYeetAbility::new));
    private volatile boolean lock = false;
    ArrayList<Runnable> delayedAttacks = new ArrayList();
    private float yeetAmount;

    public AttackYeetAbility(float yeetAmount) {
        this.yeetAmount = yeetAmount;
    }

    public float getYeetAmount() {
        return this.yeetAmount;
    }

    @SubscribeEvent
    public void onPlayerAttack(LivingDamageEvent event) {
        Player attacker;
        if (event.getSource() != null && event.getSource().m_7639_() instanceof Player && !(event.getEntityLiving() instanceof Player) && this.trackedPlayers.contains((attacker = (Player)event.getSource().m_7639_()).m_142081_())) {
            while (this.lock) {
            }
            this.lock = true;
            this.delayedAttacks.add(() -> {
                event.getEntityLiving().m_20256_(event.getEntityLiving().m_20184_().m_82520_(0.0, (double)this.yeetAmount, 0.0));
                event.getEntityLiving().f_19853_.m_5594_(null, attacker.m_142538_(), SoundEvents.f_12057_, SoundSource.MASTER, 10.0f, 1.0f);
            });
            this.lock = false;
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            while (this.lock) {
            }
            this.lock = true;
            this.delayedAttacks.forEach(attack -> attack.run());
            this.delayedAttacks.clear();
            this.lock = false;
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            while (this.lock) {
            }
            this.lock = true;
            this.delayedAttacks.forEach(attack -> attack.run());
            this.delayedAttacks.clear();
            this.lock = false;
        }
    }

    @Override
    public boolean isAbleToReceiveEvents() {
        return true;
    }
}

