/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.morph.functionality.configurable;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.budschie.bmorph.events.MotionMultiplierEvent;
import de.budschie.bmorph.main.ServerSetup;
import de.budschie.bmorph.morph.LazyTag;
import de.budschie.bmorph.morph.MorphItem;
import de.budschie.bmorph.morph.functionality.Ability;
import de.budschie.bmorph.morph.functionality.codec_addition.ModCodecs;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class BlockPassthroughAbility
extends Ability {
    public static final Codec<BlockPassthroughAbility> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.DOUBLE.fieldOf("speed_multiplier").forGetter(BlockPassthroughAbility::getWebSpeedMultiplier), (App)ModCodecs.LAZY_BLOCK_TAGS.fieldOf("applies_to").forGetter(BlockPassthroughAbility::getAppliesTo)).apply((Applicative)instance, BlockPassthroughAbility::new));
    private double webSpeedMultiplier;
    private UUID webSpeedUUID;
    private AttributeModifier am;
    private LazyTag<Block> appliesTo;
    private HashSet<UUID> wasInWeb = new HashSet();

    public BlockPassthroughAbility(double webSpeedMultiplier, LazyTag<Block> appliesTo) {
        this.webSpeedMultiplier = webSpeedMultiplier;
        this.webSpeedUUID = UUID.randomUUID();
        this.appliesTo = appliesTo;
        this.am = new AttributeModifier(this.webSpeedUUID, "web_speed_attribute_modifier", this.webSpeedMultiplier, AttributeModifier.Operation.MULTIPLY_BASE);
    }

    public LazyTag<Block> getAppliesTo() {
        return this.appliesTo;
    }

    public double getWebSpeedMultiplier() {
        return this.webSpeedMultiplier;
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            this.trackedPlayers.forEach(uuid -> {
                if (!this.wasInWeb.contains(uuid)) {
                    ServerPlayer player = ServerSetup.server.m_6846_().m_11259_(uuid);
                    player.m_21051_(Attributes.f_22279_).m_22130_(this.am);
                }
                this.wasInWeb.clear();
            });
        }
    }

    @SubscribeEvent
    public void onMotionMultiplierEvent(MotionMultiplierEvent event) {
        if (this.isTracked(event.getEntity()) && this.appliesTo.test(event.getBlockState().m_60734_())) {
            event.setCanceled(true);
            Player player = (Player)event.getEntity();
            AttributeInstance attributeInstance = player.m_21051_(Attributes.f_22279_);
            if (!attributeInstance.m_22109_(this.am)) {
                attributeInstance.m_22118_(this.am);
            }
            this.wasInWeb.add(player.m_142081_());
        }
    }

    @Override
    public void disableAbility(Player player, MorphItem disabledItem, MorphItem newMorph, List<Ability> newAbilities, Ability.AbilityChangeReason reason) {
        super.disableAbility(player, disabledItem, newMorph, newAbilities, reason);
        AttributeInstance attributeInstance = player.m_21051_(Attributes.f_22279_);
        if (attributeInstance.m_22109_(this.am)) {
            attributeInstance.m_22130_(this.am);
        }
    }

    @Override
    public boolean isAbleToReceiveEvents() {
        return true;
    }
}

