/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.morph.functionality.configurable;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.budschie.bmorph.main.ServerSetup;
import de.budschie.bmorph.morph.functionality.Ability;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class BlockTrailAbility
extends Ability {
    public static final Codec<BlockTrailAbility> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockStateProvider.f_68747_.fieldOf("trail_block").forGetter(BlockTrailAbility::getTrailBlock), (App)Codec.BOOL.optionalFieldOf("should_only_spawn_in_cold_biome", (Object)false).forGetter(BlockTrailAbility::shouldSpawnOnlyInColdBiome)).apply((Applicative)instance, BlockTrailAbility::new));
    private BlockStateProvider trailBlock;
    private boolean spawnOnlyInColdBiome;

    public BlockTrailAbility(BlockStateProvider trailBlock, boolean spawnOnlyInColdBiome) {
        this.trailBlock = trailBlock;
        this.spawnOnlyInColdBiome = spawnOnlyInColdBiome;
    }

    public BlockStateProvider getTrailBlock() {
        return this.trailBlock;
    }

    public boolean shouldSpawnOnlyInColdBiome() {
        return this.spawnOnlyInColdBiome;
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            for (UUID playerId : this.trackedPlayers) {
                this.placeTrailBlocks((Player)ServerSetup.server.m_6846_().m_11259_(playerId));
            }
        }
    }

    private void placeTrailBlocks(Player player) {
        for (int placePos = 0; placePos < 4; ++placePos) {
            int x = Mth.m_14107_((double)(player.m_20185_() + (double)(placePos % 2 == 0 ? -0.25f : 0.25f)));
            int y = Mth.m_14107_((double)player.m_20186_());
            int z = Mth.m_14107_((double)(player.m_20189_() + (double)(placePos < 2 ? -0.25f : 0.25f)));
            BlockPos blockPos = new BlockPos(x, y, z);
            BlockState blockState = this.trailBlock.m_7112_(player.m_21187_(), blockPos);
            if (!player.f_19853_.m_46859_(blockPos) || !((Biome)player.f_19853_.m_204166_(blockPos).m_203334_()).m_198910_(blockPos) && this.shouldSpawnOnlyInColdBiome() || !blockState.m_60710_((LevelReader)player.f_19853_, blockPos)) continue;
            player.f_19853_.m_46597_(blockPos, this.trailBlock.m_7112_(player.m_21187_(), blockPos));
        }
    }

    @Override
    public boolean isAbleToReceiveEvents() {
        return true;
    }
}

